/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor;

import edu.washington.cs.knowitall.extractor.Extractor;
import edu.washington.cs.knowitall.extractor.ExtractorException;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.util.ArrayList;
import java.util.Collection;

public abstract class RelationFirstNpChunkExtractor
extends Extractor<ChunkedSentence, ChunkedBinaryExtraction> {
    protected boolean allowUnary = false;
    protected Extractor<ChunkedSentence, ChunkedExtraction> relExtr;
    protected Extractor<ChunkedExtraction, ChunkedArgumentExtraction> arg1Extr;
    protected Extractor<ChunkedExtraction, ChunkedArgumentExtraction> arg2Extr;

    public Extractor<ChunkedSentence, ChunkedExtraction> getRelationExtractor() {
        return this.relExtr;
    }

    public Extractor<ChunkedExtraction, ChunkedArgumentExtraction> getArgument1Extractor() {
        return this.arg1Extr;
    }

    public Extractor<ChunkedExtraction, ChunkedArgumentExtraction> getArgument2Extractor() {
        return this.arg2Extr;
    }

    public void setRelationExtractor(Extractor<ChunkedSentence, ChunkedExtraction> relExtr) {
        this.relExtr = relExtr;
    }

    public void setArgument1Extractor(Extractor<ChunkedExtraction, ChunkedArgumentExtraction> arg1Extr) {
        this.arg1Extr = arg1Extr;
    }

    public void setArgument2Extractor(Extractor<ChunkedExtraction, ChunkedArgumentExtraction> arg2Extr) {
        this.arg2Extr = arg2Extr;
    }

    public void setAllowUnary(boolean allowUnary) {
        this.allowUnary = allowUnary;
    }

    @Override
    protected Collection<ChunkedBinaryExtraction> extractCandidates(ChunkedSentence source) throws ExtractorException {
        Extractor<ChunkedSentence, ChunkedExtraction> relExtr = this.getRelationExtractor();
        Extractor<ChunkedExtraction, ChunkedArgumentExtraction> arg1Extr = this.getArgument1Extractor();
        Extractor<ChunkedExtraction, ChunkedArgumentExtraction> arg2Extr = this.getArgument2Extractor();
        Iterable<ChunkedExtraction> rels = relExtr.extract(source);
        ArrayList<ChunkedBinaryExtraction> extrs = new ArrayList<ChunkedBinaryExtraction>();
        for (ChunkedExtraction rel : rels) {
            Iterable<ChunkedArgumentExtraction> arg1s = arg1Extr.extract(rel);
            Iterable<ChunkedArgumentExtraction> arg2s = arg2Extr.extract(rel);
            extrs.addAll(ChunkedBinaryExtraction.productOfArgs(rel, arg1s, arg2s, this.allowUnary));
        }
        return extrs;
    }
}

