/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf;

import com.google.common.base.Predicate;
import edu.washington.cs.knowitall.extractor.conf.NestedFeatures;
import edu.washington.cs.knowitall.extractor.conf.featureset.TokenFeature;
import edu.washington.cs.knowitall.extractor.conf.featureset.VerbTokenFeature;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import edu.washington.cs.knowitall.normalization.BasicFieldNormalizer;
import edu.washington.cs.knowitall.sequence.SequenceException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HypotheticalFeatures {
    private BasicFieldNormalizer stemmer = new BasicFieldNormalizer();
    private HashMap<String, Predicate<ChunkedBinaryExtraction>> featureMap;
    private static String[] ifWords = new String[]{"if", "whether", "though", "although"};
    private static String[] thatWords = new String[]{"that", "which", "who"};
    private static String[] mayWords = new String[]{"may", "might", "would", "could", "should", "suppose"};
    private Set<String> ifSet;
    private Set<String> maySet;
    private Set<String> comSet;
    private Set<String> cogSet;
    private Set<String> thatSet;

    public HypotheticalFeatures() {
        this.initKeywordSets();
        this.initFeatureSet();
    }

    private void initKeywordSets() {
        this.ifSet = new HashSet<String>();
        this.ifSet.addAll(Arrays.asList(ifWords));
        this.maySet = new HashSet<String>();
        this.maySet.addAll(Arrays.asList(mayWords));
        this.comSet = new HashSet<String>();
        this.comSet.addAll(Arrays.asList(NestedFeatures.comWords));
        this.cogSet = new HashSet<String>();
        this.cogSet.addAll(Arrays.asList(NestedFeatures.cogWords));
        this.thatSet = new HashSet<String>();
        this.thatSet.addAll(Arrays.asList(thatWords));
    }

    public Map<String, Predicate<ChunkedBinaryExtraction>> getFeatureMap() {
        return this.featureMap;
    }

    private void initFeatureSet() throws SequenceException {
        this.initFeatureMap();
    }

    private void initFeatureMap() {
        this.featureMap = new HashMap();
        this.featureMap.put("hyp: that,which,who imm before arg1", this.tokenImmediatelyBeforeArg1(this.thatSet));
        this.featureMap.put("hyp: that,which,who btw arg1/pred", this.tokenBtwArg1AndPred(this.thatSet));
        this.featureMap.put("hyp: if,whether,though,although anwh before arg1", TokenFeature.anywhereBeforeArg1(this.ifSet));
        this.featureMap.put("hyp: may,might,would,could,should,suppose anwh before arg1", TokenFeature.anywhereBeforeArg1(this.maySet));
        this.featureMap.put("hyp: communic verb anwh before arg1", VerbTokenFeature.anywhereBeforeArg1(this.comSet));
        this.featureMap.put("hyp: cognitn verb anwh before arg1", VerbTokenFeature.anywhereBeforeArg1(this.cogSet));
        this.featureMap.put("hyp: communic verb anwh after arg2", VerbTokenFeature.anywhereAfterArg2(this.comSet));
        this.featureMap.put("rel is single communication verb", VerbTokenFeature.relSingleToken(this.comSet));
    }

    private Predicate<ChunkedBinaryExtraction> tokenBtwArg1AndPred(final Set<String> keyWords) {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction extr) {
                ChunkedSentence sentence = extr.getSentence();
                ChunkedArgumentExtraction arg1 = extr.getArgument1();
                ChunkedExtraction rel = extr.getRelation();
                for (int i = arg1.getStart() + arg1.getLength(); i < rel.getStart(); ++i) {
                    String token = sentence.getToken(i);
                    String pos = sentence.getPosTag(i);
                    String lemma = HypotheticalFeatures.this.stemmer.stemSingleToken(token, pos);
                    if (!keyWords.contains(lemma.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private Predicate<ChunkedBinaryExtraction> tokenImmediatelyBeforeArg1(final Set<String> keyWords) {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction extr) {
                ChunkedSentence sentence = extr.getSentence();
                ChunkedArgumentExtraction arg1 = extr.getArgument1();
                int i = arg1.getStart() - 1;
                if (i < 0) {
                    return false;
                }
                String token = sentence.getToken(i);
                String pos = sentence.getPosTag(i);
                String lemma = HypotheticalFeatures.this.stemmer.stemSingleToken(token, pos);
                return keyWords.contains(lemma.toLowerCase());
            }
        };
    }
}

