/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf;

import edu.washington.cs.knowitall.extractor.conf.LabeledBinaryExtraction;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class LabeledBinaryExtractionWriter {
    private PrintStream out;

    public LabeledBinaryExtractionWriter(OutputStream stream) throws IOException {
        this.out = new PrintStream(stream);
    }

    public void writeExtractions(Iterable<LabeledBinaryExtraction> extrs) throws IOException {
        for (LabeledBinaryExtraction extr : extrs) {
            this.writeExtraction(extr);
        }
    }

    public void writeExtraction(LabeledBinaryExtraction extr) throws IOException {
        ChunkedSentence sent = extr.getSentence();
        this.out.println(sent.getTokensAsString());
        this.out.println(sent.getPosTagsAsString());
        this.out.println(sent.getChunkTagsAsString());
        ChunkedArgumentExtraction arg1 = extr.getArgument1();
        this.out.println(arg1.getTokensAsString());
        this.out.println(arg1.getRange().getStart() + " " + arg1.getRange().getLength());
        ChunkedExtraction rel = extr.getRelation();
        this.out.println(rel.getTokensAsString());
        this.out.println(rel.getRange().getStart() + " " + rel.getRange().getLength());
        ChunkedArgumentExtraction arg2 = extr.getArgument2();
        this.out.println(arg2.getTokensAsString());
        this.out.println(arg2.getRange().getStart() + " " + arg2.getRange().getLength());
        int label = extr.isPositive() ? 1 : 0;
        this.out.println(label);
    }
}

