/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf;

import edu.washington.cs.knowitall.extractor.ReVerbExtractor;
import edu.washington.cs.knowitall.extractor.conf.LabeledBinaryExtraction;
import edu.washington.cs.knowitall.extractor.conf.LabeledBinaryExtractionWriter;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.ChunkedSentenceReader;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import edu.washington.cs.knowitall.util.DefaultObjects;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;

public class ReVerbDataSetCreator {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: ReVerbDataSetCreator input output");
            return;
        }
        BufferedReader reader = args[0].equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(args[0]));
        ChunkedSentenceReader sentReader = DefaultObjects.getDefaultSentenceReader(reader);
        FileOutputStream outStream = new FileOutputStream(args[1]);
        LabeledBinaryExtractionWriter out = new LabeledBinaryExtractionWriter(outStream);
        ReVerbExtractor extractor = new ReVerbExtractor();
        for (ChunkedSentence sent : sentReader.getSentences()) {
            for (ChunkedBinaryExtraction extr : extractor.extract(sent)) {
                LabeledBinaryExtraction extrLabeled = new LabeledBinaryExtraction(extr, 0);
                out.writeExtraction(extrLabeled);
            }
        }
    }
}

