/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf;

import edu.washington.cs.knowitall.commonlib.ResourceUtils;
import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunction;
import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunctionException;
import edu.washington.cs.knowitall.extractor.conf.ReVerbFeatures;
import edu.washington.cs.knowitall.extractor.conf.classifier.LogisticRegression;
import edu.washington.cs.knowitall.extractor.conf.featureset.BooleanFeatureSet;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import java.io.IOException;

public class ReVerbIndependentConfFunction
implements ConfidenceFunction {
    private ReVerbFeatures reverbFeatures;
    private BooleanFeatureSet<ChunkedBinaryExtraction> featureSet;
    private final LogisticRegression<ChunkedBinaryExtraction> logreg;

    public ReVerbIndependentConfFunction() throws ConfidenceFunctionException {
        this("reverb-conf-maxent.gz");
    }

    public ReVerbIndependentConfFunction(String model) {
        try {
            this.reverbFeatures = new ReVerbFeatures();
            this.featureSet = this.reverbFeatures.getFeatureSet();
            this.logreg = new LogisticRegression<ChunkedBinaryExtraction>(this.featureSet, ResourceUtils.loadResource((String)model, this.getClass()));
        }
        catch (IOException e) {
            throw new ConfidenceFunctionException("Unable to load classifier: " + model, e);
        }
    }

    @Override
    public double getConf(ChunkedBinaryExtraction extr) throws ConfidenceFunctionException {
        try {
            return this.logreg.confidence(extr);
        }
        catch (Exception e) {
            throw new ConfidenceFunctionException(e);
        }
    }
}

