/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf;

import edu.washington.cs.knowitall.extractor.conf.LabeledBinaryExtraction;
import edu.washington.cs.knowitall.extractor.conf.LabeledBinaryExtractionReader;
import edu.washington.cs.knowitall.extractor.conf.ReVerbFeatures;
import edu.washington.cs.knowitall.extractor.conf.featureset.BooleanFeatureSet;
import edu.washington.cs.knowitall.extractor.conf.opennlp.OpenNlpDataSet;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import java.io.File;
import java.io.FileInputStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.AbstractModel;
import opennlp.model.EventStream;
import opennlp.model.ListEventStream;

public class ReVerbOpenNlpClassifierTrainer {
    private BooleanFeatureSet<ChunkedBinaryExtraction> featureSet;
    private GISModel model;
    private OpenNlpDataSet<ChunkedBinaryExtraction> dataSet;

    private ReVerbOpenNlpClassifierTrainer() {
        ReVerbFeatures feats = new ReVerbFeatures();
        this.featureSet = feats.getFeatureSet();
    }

    public ReVerbOpenNlpClassifierTrainer(Iterable<LabeledBinaryExtraction> examples) throws Exception {
        this();
        this.dataSet = new OpenNlpDataSet<ChunkedBinaryExtraction>("train", this.featureSet);
        this.loadDataSet(examples);
        this.train();
    }

    public GISModel getModel() {
        return this.model;
    }

    private void loadDataSet(Iterable<LabeledBinaryExtraction> examples) {
        for (LabeledBinaryExtraction extr : examples) {
            int label = extr.isPositive() ? 1 : 0;
            this.dataSet.addInstance(extr, label);
        }
    }

    private void train() throws Exception {
        this.model = GIS.trainModel((EventStream)new ListEventStream(this.dataSet.getInstances()), (int)100, (int)0);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: ReVerbClassifierTrainer examples model [features]\n");
            System.err.println("    Trains the model used by ReVerbConfFunction on the given examples file and\n    writes them to the given model file. Optionally, will write out the \n    training data as a Weka ARFF file. The examples must be in the format\n    described in LabeledBinaryExtractionReader. The features used in the\n    classifier are described in ReVerbFeatures.\n");
            return;
        }
        FileInputStream in = new FileInputStream(args[0]);
        LabeledBinaryExtractionReader reader = new LabeledBinaryExtractionReader(in);
        ReVerbOpenNlpClassifierTrainer trainer = new ReVerbOpenNlpClassifierTrainer(reader.readExtractions());
        GISModel model = trainer.getModel();
        File outputFile = new File(args[1]);
        SuffixSensitiveGISModelWriter writer = new SuffixSensitiveGISModelWriter((AbstractModel)model, outputFile);
        writer.persist();
    }
}

