/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf.featureset;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.washington.cs.knowitall.extractor.conf.featureset.FeatureSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class BooleanFeatureSet<T>
extends FeatureSet<T> {
    private Map<String, Predicate<T>> features;

    public BooleanFeatureSet(Map<String, Predicate<T>> givenFeatures) {
        super((List<String>)ImmutableList.copyOf(givenFeatures.keySet()));
        this.features = ImmutableMap.copyOf(givenFeatures);
    }

    public SortedMap<String, Boolean> featurize(T object) {
        TreeMap<String, Boolean> values = new TreeMap<String, Boolean>();
        for (int i = 0; i < this.getNumFeatures(); ++i) {
            String featureName = (String)this.featureNames.get(i);
            boolean featureValue = this.features.get(featureName).apply(object);
            values.put(featureName, featureValue);
        }
        return values;
    }

    @Override
    public double[] featurizeToDouble(T object) {
        double[] values = new double[this.features.size()];
        int i = 0;
        for (String featureName : this.featureNames) {
            values[i] = this.features.get(featureName).apply(object) ? 1.0 : 0.0;
            ++i;
        }
        return values;
    }

    public boolean[] featurizeToBool(T object) {
        boolean[] values = new boolean[this.features.size()];
        int i = 0;
        for (String featureName : this.featureNames) {
            values[i] = this.features.get(featureName).apply(object);
            ++i;
        }
        return values;
    }

    public Map<String, Predicate<T>> getFeatures() {
        return this.features;
    }

    @Override
    public double featurize(String featureName, T object) {
        return this.features.get(featureName).apply(object) ? 1.0 : 0.0;
    }

    public boolean featurizeToBool(String featureName, T object) {
        return this.features.get(featureName).apply(object);
    }
}

