/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf.featureset;

import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.extractor.conf.featureset.ExtractionFeature;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class ChunkFeature
extends ExtractionFeature {
    private Set<String> chunkTags = new HashSet<String>();

    public ChunkFeature(String ... givenTokens) {
        this(Arrays.asList(givenTokens));
    }

    public ChunkFeature(Collection<String> givenChunkTags) {
        this.chunkTags.addAll(givenChunkTags);
    }

    @Override
    protected abstract Range rangeToExamine(ChunkedBinaryExtraction var1);

    @Override
    protected boolean testAtIndex(Integer index, ChunkedSentence sentence) {
        String tag = sentence.getChunkTag(index);
        return this.chunkTags.contains(tag);
    }

    public static ChunkFeature withinArg2(String ... chunkTags) {
        return new ChunkFeature(chunkTags){

            @Override
            protected Range rangeToExamine(ChunkedBinaryExtraction cbe) {
                return cbe.getArgument2().getRange();
            }
        };
    }

    public static ChunkFeature withinRel(String ... chunkTags) {
        return new ChunkFeature(chunkTags){

            @Override
            protected Range rangeToExamine(ChunkedBinaryExtraction cbe) {
                return cbe.getRelation().getRange();
            }
        };
    }

    public static ChunkFeature rightBeforeArg1(String ... chunkTags) {
        return new ChunkFeature(chunkTags){

            @Override
            protected Range rangeToExamine(ChunkedBinaryExtraction cbe) {
                ChunkedArgumentExtraction arg1 = cbe.getArgument1();
                int index = arg1.getStart() - 1;
                if (index < 0 || index >= arg1.getSentence().getLength()) {
                    return Range.EMPTY;
                }
                return Range.fromInterval((int)index, (int)(index + 1));
            }
        };
    }

    public static ChunkFeature rightAfterArg2(String ... chunkTags) {
        return new ChunkFeature(chunkTags){

            @Override
            protected Range rangeToExamine(ChunkedBinaryExtraction cbe) {
                ChunkedArgumentExtraction arg2 = cbe.getArgument2();
                int index = arg2.getStart() + arg2.getLength();
                if (index < 0 || index >= arg2.getSentence().getLength()) {
                    return Range.EMPTY;
                }
                return Range.fromInterval((int)index, (int)(index + 1));
            }
        };
    }
}

