/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf.featureset;

import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.extractor.conf.featureset.ExtractionFeature;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class PosFeature
extends ExtractionFeature {
    public static final String[] allVerbPosTags = new String[]{"VB", "VBD", "VBG", "VBN", "VBP", "VBZ"};
    private Set<String> posTags = new HashSet<String>();

    public PosFeature(String ... posTags) {
        this(Arrays.asList(posTags));
    }

    public PosFeature(Collection<String> posTags) {
        this.posTags.addAll(posTags);
    }

    @Override
    protected boolean testAtIndex(Integer index, ChunkedSentence sentence) {
        String posTag = sentence.getPosTag(index);
        return this.posTags.contains(posTag);
    }

    @Override
    protected abstract Range rangeToExamine(ChunkedBinaryExtraction var1);

    public static PosFeature withinArg2(String ... posTags) {
        return new PosFeature(posTags){

            @Override
            protected Range rangeToExamine(ChunkedBinaryExtraction cbe) {
                return cbe.getArgument2().getRange();
            }
        };
    }

    public static PosFeature withinArg1(String ... posTags) {
        return new PosFeature(posTags){

            @Override
            protected Range rangeToExamine(ChunkedBinaryExtraction cbe) {
                return cbe.getArgument1().getRange();
            }
        };
    }

    public static PosFeature relSingleVerb() {
        return new PosFeature(allVerbPosTags){

            @Override
            protected Range rangeToExamine(ChunkedBinaryExtraction cbe) {
                Range range = cbe.getRelation().getRange();
                if (range.getLength() == 1) {
                    return range;
                }
                return Range.EMPTY;
            }
        };
    }

    public static PosFeature withinRel(String ... posTags) {
        return new PosFeature(posTags){

            @Override
            protected Range rangeToExamine(ChunkedBinaryExtraction cbe) {
                return cbe.getRelation().getRange();
            }
        };
    }

    public static PosFeature rightBeforeArg1(String ... posTags) {
        return new PosFeature(posTags){

            @Override
            protected Range rangeToExamine(ChunkedBinaryExtraction cbe) {
                ChunkedArgumentExtraction arg1 = cbe.getArgument1();
                int index = arg1.getStart() - 1;
                if (index < 0 || index >= arg1.getSentence().getLength()) {
                    return Range.EMPTY;
                }
                return Range.fromInterval((int)index, (int)(index + 1));
            }
        };
    }

    public static PosFeature rightAfterArg2(String ... posTags) {
        return new PosFeature(posTags){

            @Override
            protected Range rangeToExamine(ChunkedBinaryExtraction cbe) {
                ChunkedArgumentExtraction arg2 = cbe.getArgument2();
                int index = arg2.getStart() + arg2.getLength();
                if (index < 0 || index >= arg2.getSentence().getLength()) {
                    return Range.EMPTY;
                }
                return Range.fromInterval((int)index, (int)(index + 1));
            }
        };
    }

    public static PosFeature rightBeforeRel(String ... posTags) {
        return new PosFeature(posTags){

            @Override
            protected Range rangeToExamine(ChunkedBinaryExtraction cbe) {
                ChunkedExtraction rel = cbe.getRelation();
                int index = rel.getStart() - 1;
                if (index < 0 || index >= rel.getSentence().getLength()) {
                    return Range.EMPTY;
                }
                return Range.fromInterval((int)index, (int)(index + 1));
            }
        };
    }
}

