/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf.opennlp;

import com.google.common.collect.ImmutableList;
import edu.washington.cs.knowitall.extractor.conf.featureset.BooleanFeatureSet;
import edu.washington.cs.knowitall.extractor.conf.opennlp.OpenNlpAlphabet;
import java.util.ArrayList;
import java.util.List;
import opennlp.model.Event;

public class OpenNlpDataSet<T> {
    public final String name;
    private final BooleanFeatureSet<T> features;
    private final List<Event> instances;
    private final OpenNlpAlphabet<T> alphabet;

    public OpenNlpDataSet(String name, BooleanFeatureSet<T> featureSet) {
        this.name = name;
        this.features = featureSet;
        this.instances = new ArrayList<Event>();
        this.alphabet = new OpenNlpAlphabet<T>(featureSet);
    }

    public void addInstance(T instance, int label) {
        String[] stringFeatures = new String[this.features.getNumFeatures()];
        int i = 0;
        for (String feature : this.features.getFeatureNames()) {
            boolean value = this.features.featurizeToBool(feature, instance);
            stringFeatures[i++] = (String)this.alphabet.lookup.get((Object)new OpenNlpAlphabet.Key(feature, value));
        }
        Event event = new Event(Integer.toString(label), stringFeatures);
        this.instances.add(event);
    }

    public ImmutableList<Event> getInstances() {
        return ImmutableList.copyOf(this.instances);
    }
}

