/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import edu.washington.cs.knowitall.extractor.mapper.FilterMapper;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;

public class ChunkedBinaryExtractionWordCountFilter
extends FilterMapper<ChunkedBinaryExtraction> {
    private int minArgWords = 0;
    private int maxArgWords = Integer.MAX_VALUE;
    private int minPredicateWords = 0;
    private int maxPredicateWords = Integer.MAX_VALUE;

    public ChunkedBinaryExtractionWordCountFilter(int minArgWords, int maxArgWords, int minPredicateWords, int maxPredicateWords) {
        this.minArgWords = minArgWords;
        this.maxArgWords = maxArgWords;
        this.minPredicateWords = minPredicateWords;
        this.maxPredicateWords = maxPredicateWords;
    }

    @Override
    public boolean doFilter(ChunkedBinaryExtraction extraction) {
        return extraction.getArgument1().getLength() >= this.minArgWords && extraction.getArgument1().getLength() <= this.maxArgWords && extraction.getArgument2().getLength() >= this.minArgWords && extraction.getArgument2().getLength() <= this.maxArgWords && extraction.getRelation().getLength() >= this.minPredicateWords && extraction.getRelation().getLength() <= this.maxPredicateWords;
    }
}

