/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import edu.washington.cs.knowitall.extractor.mapper.IndependentMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DeUnicoder
extends IndependentMapper<String> {
    private final List<Replacement> replacements = new ArrayList<Replacement>();

    public DeUnicoder() {
        this.initializePatterns();
    }

    private void initializePatterns() {
        this.replacements.add(new Replacement(Pattern.compile("[\u201c\u201d\u201e\u201f\u275d\u275e]"), "\""));
        this.replacements.add(new Replacement(Pattern.compile("[\u2018\u2019\u201a\u201b\u275b\u275c]"), "'"));
        this.replacements.add(new Replacement(Pattern.compile("\\xa0"), " "));
    }

    @Override
    public String doMap(String sent) {
        sent = Normalizer.normalize(sent, Normalizer.Form.NFD);
        for (Replacement r : this.replacements) {
            sent = r.pattern.matcher(sent).replaceAll(r.replacement);
        }
        return sent;
    }

    public static void main(String[] args) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        DeUnicoder remover = new DeUnicoder();
        String line = reader.readLine();
        while (line != null) {
            System.out.println(remover.doMap(line));
            line = reader.readLine();
        }
    }

    static class Replacement {
        public final Pattern pattern;
        public final String replacement;

        public Replacement(Pattern pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }
    }
}

