/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import edu.washington.cs.knowitall.extractor.mapper.FilterMapper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SentenceLengthFilter
extends FilterMapper<String> {
    private int minWords = 0;
    private int maxWords = Integer.MAX_VALUE;
    private static final Pattern wordPattern = Pattern.compile("\\b\\w+\\b");

    public SentenceLengthFilter(int minWords, int maxWords) {
        this.minWords = minWords;
        this.maxWords = maxWords;
    }

    public static SentenceLengthFilter minFilter(int minWords) {
        return new SentenceLengthFilter(minWords, Integer.MAX_VALUE);
    }

    public static SentenceLengthFilter maxFilter(int maxWords) {
        return new SentenceLengthFilter(0, maxWords);
    }

    private int countWords(String s) {
        Matcher m = wordPattern.matcher(s);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count;
    }

    @Override
    public boolean doFilter(String sent) {
        int n = this.countWords(sent);
        return this.minWords <= n && n <= this.maxWords;
    }
}

