/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import edu.washington.cs.knowitall.extractor.mapper.FilterMapper;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.util.HashSet;
import java.util.Set;

public class StopListFilter
extends FilterMapper<ChunkedExtraction> {
    private Set<String> stopTokens;
    private Set<String> stopPosTags;

    public StopListFilter() {
        this.stopTokens = new HashSet<String>();
        this.stopPosTags = new HashSet<String>();
    }

    public void addStopToken(String token) {
        this.getStopTokens().add(token);
    }

    public void addStopPosTag(String posTag) {
        this.getStopPosTags().add(posTag);
    }

    public StopListFilter(Set<String> stopTokens, Set<String> stopPosTags) {
        this.stopTokens = stopTokens;
        this.stopPosTags = stopPosTags;
    }

    private static boolean containsAny(Set<String> s1, Iterable<String> s2) {
        for (String x : s2) {
            if (!s1.contains(x)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getStopTokens() {
        return this.stopTokens;
    }

    private Set<String> getStopPosTags() {
        return this.stopPosTags;
    }

    private boolean tokensValid(ChunkedExtraction extr) {
        Set<String> stopTokens = this.getStopTokens();
        return !StopListFilter.containsAny(stopTokens, extr.getTokens());
    }

    private boolean posTagsValid(ChunkedExtraction extr) {
        Set<String> stopPosTags = this.getStopPosTags();
        return !StopListFilter.containsAny(stopPosTags, extr.getPosTags());
    }

    @Override
    public boolean doFilter(ChunkedExtraction extr) {
        return this.tokensValid(extr) && this.posTagsValid(extr);
    }
}

