/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.io;

import com.google.common.collect.AbstractIterator;
import edu.washington.cs.knowitall.io.BufferedReaderIterator;
import java.io.BufferedReader;
import java.util.Iterator;
import java.util.regex.Pattern;

public class TextBlockIterator
extends AbstractIterator<String> {
    private static final int MAX_BLOCK_SIZE = 10000;
    private Iterator<String> lineIter;
    private String blockBreak = "";
    Pattern convertToSpace = Pattern.compile("\\xa0");

    public TextBlockIterator(BufferedReader reader, String blockBreak) {
        this.init((Iterator<String>)((Object)new BufferedReaderIterator(reader)), blockBreak);
    }

    public TextBlockIterator(BufferedReader reader) {
        this.init((Iterator<String>)((Object)new BufferedReaderIterator(reader)), "");
    }

    public TextBlockIterator(Iterator<String> lineIter, String blockBreak) {
        this.init(lineIter, blockBreak);
    }

    public TextBlockIterator(Iterator<String> lineIter) {
        this.init(lineIter, "");
    }

    public TextBlockIterator(Iterable<String> iter, String blockBreak) {
        this.init(iter.iterator(), blockBreak);
    }

    public TextBlockIterator(Iterable<String> iter) {
        this.init(iter.iterator(), "");
    }

    private void init(Iterator<String> lineIter, String blockBreak) {
        this.lineIter = lineIter;
        this.blockBreak = blockBreak;
    }

    private String cleanupLine(String line) {
        return this.convertToSpace.matcher(line).replaceAll(" ").trim();
    }

    protected String computeNext() {
        while (this.lineIter.hasNext()) {
            String line = this.cleanupLine(this.lineIter.next());
            StringBuffer buf = new StringBuffer(line).append(" ");
            for (int linesRead = 0; this.lineIter.hasNext() && !line.equals(this.blockBreak) && linesRead < 10000; ++linesRead) {
                line = this.cleanupLine(this.lineIter.next());
                buf.append(line).append(" ");
            }
            String result = buf.toString();
            if (result.equals("")) continue;
            return result.trim();
        }
        return (String)this.endOfData();
    }
}

