/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.nlp;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ChunkedSentenceToken {
    public final ChunkedSentence ChunkedSentence;
    public final int index;
    public static final Function<ChunkedSentenceToken, String> toStringFunction = new Function<ChunkedSentenceToken, String>(){

        public String apply(ChunkedSentenceToken token) {
            return token.ChunkedSentence.getToken(token.index);
        }
    };

    public ChunkedSentenceToken(ChunkedSentence ChunkedSentence2, int index) {
        this.ChunkedSentence = ChunkedSentence2;
        this.index = index;
    }

    public static List<ChunkedSentenceToken> tokenize(ChunkedSentence sentence) {
        return ChunkedSentenceToken.tokenize(sentence, sentence.getRange());
    }

    public static List<ChunkedSentenceToken> tokenize(ChunkedSentence sentence, Range range) {
        ArrayList<ChunkedSentenceToken> tokens = new ArrayList<ChunkedSentenceToken>(sentence.getLength());
        for (int i = range.getStart(); i < range.getEnd(); ++i) {
            tokens.add(new ChunkedSentenceToken(sentence, i));
        }
        return tokens;
    }

    public String string() {
        return (String)this.ChunkedSentence.getTokens().get(this.index);
    }

    public String pos() {
        return this.ChunkedSentence.getPosTag(this.index);
    }

    public String chunk() {
        return this.ChunkedSentence.getChunkTag(this.index);
    }

    public String toString() {
        return this.ChunkedSentence.getToken(this.index);
    }

    protected static class ChunkTagExpression
    extends Expression {
        final Pattern pattern;

        public ChunkTagExpression(String string, int flags) {
            this.pattern = Pattern.compile(string, flags);
        }

        public ChunkTagExpression(String string) {
            this(string, 2);
        }

        public boolean apply(ChunkedSentenceToken token) {
            return this.pattern.matcher(token.chunk()).matches();
        }
    }

    protected static class PosTagExpression
    extends Expression {
        final Pattern pattern;

        public PosTagExpression(String string, int flags) {
            this.pattern = Pattern.compile(string, flags);
        }

        public PosTagExpression(String string) {
            this(string, 2);
        }

        public boolean apply(ChunkedSentenceToken token) {
            return this.pattern.matcher(token.pos()).matches();
        }
    }

    protected static class StringExpression
    extends Expression {
        final Pattern pattern;

        public StringExpression(String string, int flags) {
            this.pattern = Pattern.compile(string, flags);
        }

        public StringExpression(String string) {
            this(string, 2);
        }

        public boolean apply(ChunkedSentenceToken token) {
            return this.pattern.matcher(token.string()).matches();
        }
    }

    protected static abstract class Expression
    implements Predicate<ChunkedSentenceToken> {
        protected Expression() {
        }
    }
}

