/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.nlp;

import com.google.common.collect.AbstractIterator;
import edu.washington.cs.knowitall.extractor.ExtractorException;
import edu.washington.cs.knowitall.extractor.SentenceExtractor;
import java.util.ArrayList;
import java.util.Iterator;

public class SentenceBlocksIterator
extends AbstractIterator<String> {
    private Iterator<String> sentIter;
    private Iterator<String> blockIter;
    private SentenceExtractor sentExtractor;

    public SentenceBlocksIterator(Iterator<String> blockIter, SentenceExtractor sentExtractor) {
        this.blockIter = blockIter;
        this.sentExtractor = sentExtractor;
    }

    private void computeNextSentIter() {
        String block = this.blockIter.next().trim();
        if (block.length() == 0) {
            this.sentIter = new ArrayList().iterator();
        } else {
            try {
                this.sentIter = this.sentExtractor.extract(block).iterator();
            }
            catch (ExtractorException e) {
                this.sentIter = new ArrayList().iterator();
            }
        }
    }

    protected String computeNext() {
        if (this.sentIter == null && this.blockIter.hasNext()) {
            this.computeNextSentIter();
        } else if (this.sentIter == null && !this.blockIter.hasNext()) {
            return (String)this.endOfData();
        }
        while (this.sentIter.hasNext() || this.blockIter.hasNext()) {
            if (this.sentIter.hasNext()) {
                return this.sentIter.next();
            }
            if (!this.blockIter.hasNext()) continue;
            this.computeNextSentIter();
        }
        return (String)this.endOfData();
    }
}

