/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.nlp.extraction;

import com.google.common.collect.Iterables;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import edu.washington.cs.knowitall.nlp.extraction.SpanExtraction;
import java.util.ArrayList;
import java.util.Collection;

public class ChunkedBinaryExtraction
extends SpanExtraction {
    private ChunkedExtraction rel;
    private ChunkedArgumentExtraction arg1;
    private ChunkedArgumentExtraction arg2;
    public static final String ARG1 = "ARG1";
    public static final String REL = "REL";
    public static final String ARG2 = "ARG2";
    private static final String[] fieldNames = new String[]{"ARG1", "REL", "ARG2"};

    public ChunkedBinaryExtraction(ChunkedExtraction rel, ChunkedArgumentExtraction arg1, ChunkedArgumentExtraction arg2) {
        super(new ChunkedExtraction[]{arg1, rel, arg2}, fieldNames);
        this.rel = rel;
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    public ChunkedArgumentExtraction getArgument1() {
        return this.arg1;
    }

    public ChunkedExtraction getRelation() {
        return this.rel;
    }

    public ChunkedArgumentExtraction getArgument2() {
        return this.arg2;
    }

    public Iterable<Integer> getIndices() {
        return Iterables.concat((Iterable)this.getArgument1().getRange(), (Iterable)this.getRelation().getRange(), (Iterable)this.getArgument2().getRange());
    }

    public Iterable<String> getTokens() {
        return Iterables.concat(this.getArgument1().getPosTags(), this.getRelation().getPosTags(), this.getArgument2().getPosTags());
    }

    public Iterable<String> getPosTags() {
        return Iterables.concat(this.getArgument1().getPosTags(), this.getRelation().getPosTags(), this.getArgument2().getPosTags());
    }

    public Iterable<String> getChunkTags() {
        return Iterables.concat(this.getArgument1().getChunkTags(), this.getRelation().getChunkTags(), this.getArgument2().getChunkTags());
    }

    public String toString() {
        String arg1Str = this.getArgument1().toString();
        String relStr = this.getRelation().toString();
        String arg2Str = this.getArgument2().toString();
        return String.format("(%s, %s, %s)", arg1Str, relStr, arg2Str);
    }

    public static Collection<ChunkedBinaryExtraction> productOfArgs(ChunkedExtraction rel, Iterable<? extends ChunkedArgumentExtraction> arg1s, Iterable<? extends ChunkedArgumentExtraction> arg2s) {
        return ChunkedBinaryExtraction.productOfArgs(rel, arg1s, arg2s, false);
    }

    public static Collection<ChunkedBinaryExtraction> productOfArgs(ChunkedExtraction rel, Iterable<? extends ChunkedArgumentExtraction> arg1s, Iterable<? extends ChunkedArgumentExtraction> arg2s, boolean allowUnaryRelations) {
        ChunkedBinaryExtraction extr;
        ArrayList<ChunkedBinaryExtraction> results = new ArrayList<ChunkedBinaryExtraction>();
        for (ChunkedArgumentExtraction chunkedArgumentExtraction : arg1s) {
            for (ChunkedArgumentExtraction chunkedArgumentExtraction2 : arg2s) {
                extr = new ChunkedBinaryExtraction(rel, chunkedArgumentExtraction, chunkedArgumentExtraction2);
                results.add(extr);
            }
        }
        if (allowUnaryRelations && results.isEmpty()) {
            Range dummyRange;
            for (ChunkedArgumentExtraction chunkedArgumentExtraction : arg1s) {
                dummyRange = new Range(rel.getRange().getStart() + rel.getRange().getLength(), 0);
                ChunkedArgumentExtraction chunkedArgumentExtraction3 = new ChunkedArgumentExtraction(rel.getSentence(), dummyRange, rel);
                extr = new ChunkedBinaryExtraction(rel, chunkedArgumentExtraction, chunkedArgumentExtraction3);
                results.add(extr);
            }
            for (ChunkedArgumentExtraction chunkedArgumentExtraction : arg2s) {
                dummyRange = new Range(rel.getRange().getStart(), 0);
                ChunkedArgumentExtraction chunkedArgumentExtraction4 = new ChunkedArgumentExtraction(rel.getSentence(), dummyRange, rel);
                extr = new ChunkedBinaryExtraction(rel, chunkedArgumentExtraction4, chunkedArgumentExtraction);
                results.add(extr);
            }
        }
        return results;
    }
}

