/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.nlp.extraction;

import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;

public class ChunkedExtraction
extends ChunkedSentence {
    private final Range range;
    private final ChunkedSentence sent;
    private String string;

    public ChunkedExtraction(ChunkedSentence sent, Range range) {
        super(sent.getSubSequence(range));
        this.range = range;
        this.sent = sent;
        this.string = null;
    }

    public ChunkedExtraction(ChunkedSentence sent, Range range, String string) {
        super(sent.getSubSequence(range));
        this.range = range;
        this.sent = sent;
        this.string = string;
    }

    public int getStart() {
        return this.getRange().getStart();
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    public ChunkedSentence getSentence() {
        return this.sent;
    }

    public boolean isAdjacentOrOverlaps(ChunkedExtraction extr) {
        return this.getRange().isAdjacentOrOverlaps(extr.getRange());
    }

    public boolean overlapsWith(ChunkedExtraction extr) {
        return this.getRange().overlapsWith(extr.getRange());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        result = 31 * result + (this.sent == null ? 0 : this.sent.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkedExtraction other = (ChunkedExtraction)obj;
        if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
            return false;
        }
        return !(this.sent == null ? other.sent != null : !this.sent.equals(other.sent));
    }

    public String getText() {
        if (this.string == null) {
            this.string = this.sent.getTokensAsString(this.getRange());
        }
        return this.string;
    }

    @Override
    public String toString() {
        return this.getText();
    }
}

