/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.normalization;

import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import edu.washington.cs.knowitall.normalization.FieldNormalizer;
import edu.washington.cs.knowitall.normalization.NormalizedField;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import uk.ac.susx.informatics.Morpha;

public class BasicFieldNormalizer
implements FieldNormalizer {
    private Morpha lexer = new Morpha((InputStream)new ByteArrayInputStream("".getBytes()));

    @Override
    public NormalizedField normalizeField(ChunkedExtraction field) {
        String[] normTokens = new String[field.getLength()];
        for (int i = 0; i < field.getLength(); ++i) {
            normTokens[i] = this.stem(field.getToken(i), field.getPosTag(i));
        }
        return new NormalizedField(field, normTokens, (String[])field.getPosTags().toArray((Object[])new String[normTokens.length]));
    }

    private String stem(String token, String posTag) {
        token = token.toLowerCase();
        String wordTag = token + "_" + posTag;
        try {
            this.lexer.yyreset((Reader)new StringReader(wordTag));
            this.lexer.yybegin(4);
            String tokenNorm = this.lexer.next();
            if (tokenNorm == null) {
                return token;
            }
            return tokenNorm;
        }
        catch (Throwable e) {
            return token;
        }
    }

    public String stemSingleToken(String token, String posTag) {
        return this.stem(token, posTag);
    }
}

