/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.normalization;

import java.util.Scanner;

public class RelationString
implements Comparable<RelationString> {
    private String m_pred;
    private String m_normPred;
    private String m_posPred;

    public RelationString(String m_pred, String m_normPred, String m_posPred) {
        this.m_pred = m_pred;
        this.m_normPred = m_normPred;
        this.m_posPred = m_posPred;
    }

    public void setRelationString(RelationString other) {
        this.m_pred = other.m_pred;
        this.m_normPred = other.m_normPred;
        this.m_posPred = other.m_posPred;
    }

    private void clearPredicate() {
        this.m_pred = "";
        this.m_normPred = "";
        this.m_posPred = "";
    }

    public String getPred() {
        return this.m_pred;
    }

    public void setPred(String m_pred) {
        this.m_pred = m_pred;
    }

    public String getNormPred() {
        return this.m_normPred;
    }

    public void setNormPred(String m_normPred) {
        this.m_normPred = m_normPred;
    }

    public String getPosPred() {
        return this.m_posPred;
    }

    public void setPosPred(String m_posPred) {
        this.m_posPred = m_posPred;
    }

    public String toString() {
        return this.m_pred + "\t" + this.m_normPred + "\t" + this.m_posPred;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_pred == null ? 0 : this.m_pred.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationString other = (RelationString)obj;
        return !(this.m_pred == null ? other.m_pred != null : !this.m_pred.equals(other.m_pred));
    }

    @Override
    public int compareTo(RelationString o) {
        return this.m_pred.compareTo(o.m_pred);
    }

    public void correctNormalization() {
        if (this.m_pred.length() == 0) {
            throw new IllegalArgumentException("pos-tagged predicate has zero length");
        }
        if (!Character.isLetter(this.m_pred.charAt(0)) && !this.startsWithShortenedAux(this.m_pred)) {
            this.clearPredicate();
        } else {
            this.m_normPred = this.m_normPred.toLowerCase();
            this.setRelationString(this.omitAdverbs());
            this.setRelationString(this.handleQuasiModals());
            this.setRelationString(this.omitModals());
            this.setRelationString(this.handleHave());
            this.postProcess();
            if (this.m_normPred.equals("be") || this.m_normPred.equals("do")) {
                this.clearPredicate();
            }
        }
    }

    private void postProcess() {
        if (this.m_normPred.equals("be") || this.m_normPred.equals("do") || this.m_normPred.equals("be be") || this.m_normPred.equals("do do")) {
            this.clearPredicate();
        } else if (this.m_normPred.contains("have have ") || this.m_normPred.contains("do do ") || this.m_normPred.contains("be be ")) {
            this.clearPredicate();
        } else if (!Character.isLetter(this.m_normPred.charAt(0)) && !this.startsWithShortenedAux(this.m_normPred)) {
            this.clearPredicate();
        }
    }

    private RelationString handleHave() {
        String[] normTokens = this.m_normPred.split("\\s+");
        String[] posTokens = this.m_posPred.split("\\s+");
        StringBuilder normBuilder = new StringBuilder();
        StringBuilder posBuilder = new StringBuilder();
        for (int i = 0; i < posTokens.length; ++i) {
            if (normTokens[i].equals("have") && i < posTokens.length - 1 && (posTokens[i + 1].equals("VBN") || posTokens[i + 1].equals("VB") || posTokens[i + 1].equals("VBD"))) {
                normBuilder.append(normTokens[i + 1] + " ");
                posBuilder.append("VBD ");
                ++i;
                continue;
            }
            normBuilder.append(normTokens[i] + " ");
            posBuilder.append(posTokens[i] + " ");
        }
        return new RelationString(this.m_pred, normBuilder.toString().trim(), posBuilder.toString().trim());
    }

    private RelationString handleQuasiModals() {
        String[] normTokens = this.m_normPred.split("\\s+");
        String[] posTokens = this.m_posPred.split("\\s+");
        StringBuilder normBuilder = new StringBuilder();
        StringBuilder posBuilder = new StringBuilder();
        for (int i = 0; i < posTokens.length; ++i) {
            if (i < posTokens.length - 2) {
                if (normTokens[i].equals("ought") && normTokens[i + 1].equals("to") && posTokens[i + 2].equals("VB")) {
                    ++i;
                    continue;
                }
                if (normTokens[i].equals("have") && normTokens[i + 1].equals("to") && posTokens[i + 2].equals("VB")) {
                    ++i;
                    continue;
                }
                if (normTokens[i].equals("use") && normTokens[i + 1].equals("to") && posTokens[i + 2].equals("VB") && this.m_pred.contains("used")) {
                    ++i;
                    continue;
                }
                if (i < posTokens.length - 3 && normTokens[i].equals("be") && normTokens[i + 1].equals("able") && normTokens[i + 2].equals("to") && posTokens[i + 3].equals("VB")) {
                    i += 2;
                    continue;
                }
                normBuilder.append(normTokens[i] + " ");
                posBuilder.append(posTokens[i] + " ");
                continue;
            }
            normBuilder.append(normTokens[i] + " ");
            posBuilder.append(posTokens[i] + " ");
        }
        return new RelationString(this.m_pred, normBuilder.toString().trim(), posBuilder.toString().trim());
    }

    private RelationString omitAdverbs() {
        String[] posTokens;
        String[] normTokens = this.m_normPred.split("\\s+");
        if (normTokens.length != (posTokens = this.m_posPred.split("\\s+")).length) {
            throw new IllegalArgumentException("different number of tokens in: " + this.m_normPred + " and " + this.m_posPred);
        }
        StringBuilder normBuilder = new StringBuilder();
        StringBuilder posBuilder = new StringBuilder();
        for (int i = 0; i < posTokens.length; ++i) {
            if (posTokens[i].equals("RB")) continue;
            normBuilder.append(normTokens[i] + " ");
            posBuilder.append(posTokens[i] + " ");
        }
        return new RelationString(this.m_pred, normBuilder.toString().trim(), posBuilder.toString().trim());
    }

    private RelationString omitModals() {
        String[] posTokens;
        String[] normTokens = this.m_normPred.split("\\s+");
        if (normTokens.length != (posTokens = this.m_posPred.split("\\s+")).length) {
            throw new IllegalArgumentException("different number of tokens in: " + this.m_normPred + " and " + this.m_posPred);
        }
        StringBuilder normBuilder = new StringBuilder();
        StringBuilder posBuilder = new StringBuilder();
        for (int i = 0; i < posTokens.length; ++i) {
            if (posTokens[i].equals("MD")) continue;
            normBuilder.append(normTokens[i] + " ");
            posBuilder.append(posTokens[i] + " ");
        }
        return new RelationString(this.m_pred, normBuilder.toString().trim(), posBuilder.toString().trim());
    }

    private boolean startsWithShortenedAux(String predicate) {
        return predicate.startsWith("'d ") || predicate.startsWith("'D ") || predicate.startsWith("'ll ") || predicate.startsWith("'LL ") || predicate.startsWith("'m ") || predicate.startsWith("'M ") || predicate.startsWith("'re ") || predicate.startsWith("'RE ") || predicate.startsWith("'s ") || predicate.startsWith("'S ") || predicate.startsWith("'ve ") || predicate.startsWith("'VE ");
    }

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            String[] parts = line.split("\t");
            System.out.println("input: " + line);
            RelationString relst = new RelationString(parts[0], parts[1], parts[2]);
            relst.correctNormalization();
            System.out.println("output: " + relst.toString());
        }
    }
}

