/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.sequence;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import edu.washington.cs.knowitall.sequence.SequenceException;
import edu.washington.cs.knowitall.sequence.StringArrayWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Encoder {
    public static final int MAX_SIZE = 65535;
    public static final String UNK = "<UNK>";
    private List<Set<String>> alphabets;
    private HashMap<StringArrayWrapper, Integer> encodingTable;

    public Encoder(List<Set<String>> symbols) throws SequenceException {
        int i;
        this.alphabets = new ArrayList<Set<String>>(symbols.size());
        int encodingTableSize = 1;
        for (i = 0; i < symbols.size(); ++i) {
            Set<String> symbolSet = symbols.get(i);
            HashSet<String> alphabet = new HashSet<String>(symbolSet.size() + 1);
            alphabet.add(UNK);
            for (String token : symbolSet) {
                if (!token.equals(UNK)) {
                    alphabet.add(token);
                    continue;
                }
                String msg = String.format("Cannot create encoding table: symbol set %s contains the \"unknown\" symbol %s", i, UNK);
                throw new SequenceException(msg);
            }
            this.alphabets.add(alphabet);
            encodingTableSize *= alphabet.size();
        }
        if (encodingTableSize > 65535) {
            throw new SequenceException("Maximum size exceeded");
        }
        this.encodingTable = new HashMap(encodingTableSize);
        i = 0;
        for (List tupleAr : Sets.cartesianProduct(this.alphabets)) {
            StringArrayWrapper tuple = new StringArrayWrapper(tupleAr.toArray(new String[0]));
            this.encodingTable.put(tuple, i);
            ++i;
        }
    }

    public int size() {
        return this.alphabets.size();
    }

    public int tableSize() {
        return this.encodingTable.size();
    }

    public char encode(String[] tuple) throws SequenceException {
        if (tuple.length != this.size()) {
            String msg = String.format("Invalid tuple size: expected %s, got %s", this.size(), tuple.length);
            throw new SequenceException(msg);
        }
        for (int i = 0; i < tuple.length; ++i) {
            String val = tuple[i];
            if (!val.equals(UNK)) continue;
            String tupleStr = "(" + Joiner.on((String)", ").join((Object[])tuple) + ")";
            String msg = String.format("Symbol at position %s in %s equals %s", i, tupleStr, UNK);
            throw new SequenceException(msg);
        }
        return this.encodeMapped(this.mapToUnkown(tuple));
    }

    private char encodeMapped(String[] tuple) throws SequenceException {
        StringArrayWrapper wrappedTup = new StringArrayWrapper(tuple);
        if (this.encodingTable.containsKey(wrappedTup)) {
            char[] enc = Character.toChars(this.encodingTable.get(wrappedTup));
            assert (enc.length == 1);
            return enc[0];
        }
        String tupStr = "(" + Joiner.on((String)", ").join((Object[])tuple) + ")";
        System.out.println("---------------");
        throw new SequenceException("Could not get encoding for: " + tupStr);
    }

    public char[] encodeClass(int index, String value) throws SequenceException {
        if (index < 0 || index >= this.size()) {
            String msg = String.format("Cannot get encoding class with index = %s and value = '%s': index out of bounds", index, value);
            throw new SequenceException(msg);
        }
        ArrayList<Character> result = new ArrayList<Character>();
        for (StringArrayWrapper tuple : this.encodingTable.keySet()) {
            String[] tupData = tuple.getData();
            if (!tupData[index].equals(value)) continue;
            result.add(Character.valueOf(this.encodeMapped(tupData)));
        }
        char[] resultA = new char[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            resultA[i] = ((Character)result.get(i)).charValue();
        }
        return resultA;
    }

    private String[] mapToUnkown(String[] tuple) throws SequenceException {
        String[] result = new String[tuple.length];
        for (int i = 0; i < tuple.length; ++i) {
            Set<String> knowns = this.alphabets.get(i);
            if (tuple[i].equals(UNK)) continue;
            result[i] = knowns.contains(tuple[i]) ? tuple[i] : UNK;
        }
        return result;
    }
}

