/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.sequence;

import edu.washington.cs.knowitall.sequence.SequenceException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LayeredPatternTokenizer {
    private final String tokenPatternStr = "([a-zA-Z0-9\\-.,:;?!\"'`$]+)_([a-zA-Z0-9\\-]+)";
    private final Pattern tokenPattern = Pattern.compile("([a-zA-Z0-9\\-.,:;?!\"'`$]+)_([a-zA-Z0-9\\-]+)");
    private final String[] metaChars = new String[]{"(", "[", "{", "\\", "^", "$", "|", "]", "}", ")", "?", "*", "+", ".", ":", "=", "!", "<", ">"};
    private Set<String> metaCharSet = new HashSet<String>();

    public LayeredPatternTokenizer() {
        for (String metaChar : this.metaChars) {
            this.metaCharSet.add(metaChar);
        }
    }

    public String[] tokenize(String text) throws SequenceException {
        String candidate;
        if (text == null) {
            text = "";
        }
        int lastMatch = 0;
        LinkedList<String> splitted = new LinkedList<String>();
        Matcher m = this.tokenPattern.matcher(text);
        while (m.find()) {
            candidate = text.substring(lastMatch, m.start());
            if (!candidate.matches("^\\s*$")) {
                this.addCharsOfString(text, candidate, splitted);
            }
            splitted.add(m.group());
            lastMatch = m.end();
        }
        candidate = text.substring(lastMatch);
        if (!candidate.matches("^\\s*$")) {
            this.addCharsOfString(text, text.substring(lastMatch), splitted);
        }
        return splitted.toArray(new String[splitted.size()]);
    }

    private void addCharsOfString(String text, String s, List<String> l) throws SequenceException {
        for (int i = 0; i < s.length(); ++i) {
            String token = s.substring(i, i + 1);
            if (this.isMetaChar(token)) {
                l.add(s.substring(i, i + 1));
                continue;
            }
            if (token.matches("^\\s*$")) continue;
            String msg = String.format("Could not tokenize pattern '%s': token '%s' is not a layer/symbol pair or a meta-character", text, token);
            throw new SequenceException(msg);
        }
    }

    public boolean isSymbolLayerName(String text) {
        return this.tokenPattern.matcher(text).matches();
    }

    private boolean isMetaChar(String s) {
        return this.metaCharSet.contains(s);
    }

    public String[] getSymbolLayerName(String text) {
        return text.split("_");
    }
}

