/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    private final T[] array;
    private int nextPos;
    private final int upperBound;

    public ArrayIterator(T[] array) {
        this.array = array;
        this.upperBound = array.length;
        this.nextPos = 0;
    }

    public ArrayIterator(T[] array, int lowerBound, int length) {
        if (lowerBound < 0 || length <= 0 || length + lowerBound > array.length) {
            throw new IllegalArgumentException();
        }
        this.array = array;
        this.upperBound = lowerBound + length;
        this.nextPos = lowerBound;
    }

    @Override
    public boolean hasNext() {
        return this.nextPos < this.upperBound;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T ret = this.array[this.nextPos];
            ++this.nextPos;
            return ret;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

