/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.util;

import edu.washington.cs.knowitall.util.WarcReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;

public class WarcPage {
    private String WARC_Target_URI;
    private String WARC_TREC_ID;
    private StringBuilder lines;
    private final long serialNumber;

    public WarcPage(long serialNumber) {
        this.serialNumber = serialNumber;
        this.lines = new StringBuilder();
    }

    public static WarcPage fromString(String pageString) {
        WarcReader tempReader = new WarcReader(new BufferedReader(new StringReader(pageString)));
        Iterator<WarcPage> wit = tempReader.iterator();
        if (wit.hasNext()) {
            return wit.next();
        }
        return null;
    }

    public String getContent() {
        return this.lines.toString();
    }

    public void addLine(String line) {
        this.lines.append("\n" + line);
    }

    public void setWARC_Target_URI(String wARC_Target_URI) {
        this.WARC_Target_URI = wARC_Target_URI;
    }

    public String getWARC_Target_URI() {
        return this.WARC_Target_URI;
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public boolean hasContent() {
        return this.lines.length() > 0;
    }

    public StringReader getPageReader() throws IOException {
        return new StringReader(this.lines.toString());
    }

    public void setWARC_TREC_ID(String wARC_TREC_ID) {
        this.WARC_TREC_ID = wARC_TREC_ID;
    }

    public String getWARC_TREC_ID() {
        return this.WARC_TREC_ID;
    }
}

