/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.util;

import edu.washington.cs.knowitall.util.WarcPage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class WarcReader
implements Iterable<WarcPage> {
    private final BufferedReader in;
    protected long serialNumber;

    public WarcReader(BufferedReader in) {
        this.in = in;
    }

    public WarcReader(InputStream is) throws IOException {
        this(new BufferedReader(new InputStreamReader(is)));
    }

    @Override
    public Iterator<WarcPage> iterator() {
        return new Iterator<WarcPage>(){
            WarcPage w = null;

            @Override
            public boolean hasNext() {
                String line;
                if (this.w != null) {
                    return true;
                }
                this.w = new WarcPage(WarcReader.this.serialNumber++);
                int count = 2;
                while (count > 0) {
                    try {
                        line = WarcReader.this.in.readLine();
                    }
                    catch (IOException e) {
                        return false;
                    }
                    if (line == null) {
                        return false;
                    }
                    if (line.startsWith("WARC-Target-URI")) {
                        this.w.setWARC_Target_URI(line.substring(17));
                    }
                    if (line.startsWith("WARC-TREC-ID")) {
                        this.w.setWARC_TREC_ID(line.substring(14));
                    }
                    if (!line.startsWith("Content-Length:")) continue;
                    --count;
                }
                while (true) {
                    try {
                        line = WarcReader.this.in.readLine();
                    }
                    catch (IOException e) {
                        break;
                    }
                    if (line == null || line.startsWith("WARC/0.18")) break;
                    this.w.addLine(line);
                }
                return true;
            }

            @Override
            public WarcPage next() {
                WarcPage result = this.w;
                this.w = null;
                return result;
            }

            @Override
            public void remove() {
                this.next();
            }
        };
    }
}

