/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.argumentidentifier;

import edu.washington.cs.knowitall.argumentidentifier.ArgLearnerFeatureSet;
import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunction;
import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunctionException;
import edu.washington.cs.knowitall.extractor.conf.classifier.LogisticRegression;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ConfidenceMetric
implements ConfidenceFunction {
    private static URL MODEL_URL = ConfidenceMetric.class.getResource("/r2a2-conf.weights");
    private final LogisticRegression<ChunkedBinaryExtraction> logreg;

    public ConfidenceMetric() throws IOException {
        this(MODEL_URL);
    }

    public ConfidenceMetric(LogisticRegression<ChunkedBinaryExtraction> logreg) throws IOException {
        this.logreg = logreg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfidenceMetric(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        try {
            this.logreg = new LogisticRegression<ChunkedBinaryExtraction>(new ArgLearnerFeatureSet(), in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    @Override
    public double getConf(ChunkedBinaryExtraction extr) throws ConfidenceFunctionException {
        return this.logreg.confidence(extr);
    }
}

