/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.argumentidentifier;

import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.nlp.ChunkedSentencePattern;
import edu.washington.cs.knowitall.nlp.ChunkedSentenceToken;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import edu.washington.cs.knowitall.regex.Match;
import edu.washington.cs.knowitall.regex.RegularExpression;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class PatternExtractor {
    public static String CAPS = "[A-Z\u00e7\u00ea\u00f2\u00e9\u00f1\u0082\u00ec]";
    public static String ALPHA = "[A-Z\u00e7\u00ea\u00f2\u00e9\u00f1\u0082\u00eca-z\u0088\u0093\u009d\u008e\u0097\u008d\u0095]";
    public static String ALPHANUM = "[A-Z\u00e7\u00ea\u00f2\u00e9\u00f1\u0082\u00eca-z\u0088\u0093\u009d\u008e\u0097\u008d\u00950-9]";
    public static String PUNT = "[,\\.;:?!()-]";
    public static String np = "(?:<chunk='B-NP'> <chunk='I-NP'>*)";
    public static String vp = "(?:<chunk='B-VP'> <chunk='I-VP'>* <chunk='B-PRT'>?)";
    public static String comma = "(?:<string=','>)";
    public static String and = "(?:<string='and'>)";
    public static String or = "(?:<string='or'>)";
    public static String adjp = "(?:<chunk='B-ADJP'> <chunk='I-ADJP'>*)";
    public static String advp = "(?:<chunk='B-ADVP'> <chunk='I-ADVP'>*)";
    public static String np_pp = "(?:<chunk='B-NP'> <chunk='I-NP'>* (?:<chunk='B-PP'> <chunk='B-NP'> <chunk='I-NP'>*)*)";
    public static String pp_np1 = "(?:<chunk='B-PP'> <chunk='B-NP'> <chunk='I-NP'>* (?:<chunk='B-PP'> <chunk='B-NP'> <chunk='I-NP'>*)*)";
    public static String pp_np2 = "(?:<chunk='B-PP'>? <chunk='B-NP'> <chunk='I-NP'>* (?:<chunk='B-PP'> <chunk='B-NP'> <chunk='I-NP'>*)*)";
    public static String vp1 = "(?:(?:<pos='VBD'> | <pos='VB'> | <pos='VBZ'> | <pos='VBP'> | <pos='MD'> | <pos='VBG'> | <pos='VBN'>) <chunk='I-VP'>* <chunk='B-PRT'>?)";
    public static String vp2 = "(?:(?:<pos='VBD'> | <pos='VB'> | <pos='VBZ'> | <pos='VBP'> | <pos='MD'>) <chunk='I-VP'>* <chunk='B-PRT'>?)";
    public static String vp3 = "(?:<pos='TO'> <chunk='I-VP'>+ <chunk='B-PRT'>?)";
    public static String advp_vp_advp = "(?:" + advp + "? " + vp1 + " " + advp + "?)";
    public static String pp = "(?:<chunk='B-PP'> <chunk='I-PP'>*)";
    public static String introduces_if = "(?:<string='if'> | <string='as'> | <string='while'> | <string='so'> | <string='although'> | <string='whether'> | <string='why'> | <string='where'> | <string='because'> | <string='but'>)";
    public static String vp_np = "(?:" + advp + "? " + vp + " (?:" + pp_np2 + " (?:<string=','>? <pos='CC'>? " + pp_np2 + ")*)*)";
    private HashMap<String, String> patternMapArg1 = new HashMap();
    private HashMap<String, RegularExpression<ChunkedSentenceToken>> compiledPatternMapArg1 = new HashMap();
    private HashMap<String, String> patternMapArg2 = new HashMap();
    private HashMap<String, RegularExpression<ChunkedSentenceToken>> compiledPatternMapArg2 = new HashMap();

    public PatternExtractor() {
        this.initPatternMap();
        this.initCompiledPatternMap();
    }

    private void initPatternMap() {
        this.patternMapArg1.put("between_commas", "<>* " + comma + " <>* " + comma + " <>*");
        this.patternMapArg1.put("between_quotes", "<>* <string='``'> <>* <string=''''> <>*");
        this.patternMapArg1.put("verb_np", "<>* " + vp2 + " " + np);
        this.patternMapArg1.put("double_np", "<>* " + np + " " + np);
        this.patternMapArg1.put("if", "<>* <string='if'> <>");
        this.patternMapArg1.put("app_strict", np_pp + " " + comma + " (" + np + " " + pp + ")* " + np + " " + comma + "?");
        this.patternMapArg1.put("app_1", np + " " + comma + " (" + adjp + "? " + pp + "? " + vp + "? " + pp + "?)? " + "(" + np + " " + advp + "? " + pp + "? " + comma + "? <pos='CC'>?)? " + np + " <string='.'>? " + comma + " (<pos='WDT'> | <pos='WP'> | <string='that'>)? " + advp + "? ");
        this.patternMapArg1.put("app_2", np + " " + comma + " (<pos='VBN'> " + pp + "*)? " + "(" + np + " " + advp + "? " + pp + "? " + comma + "? <pos='CC'>?)? " + np + " <string='.'>? " + comma + " " + advp + "? ");
        this.patternMapArg1.put("app_3", np_pp + " " + comma + " " + "((" + pp + " " + np + ") " + np + " " + comma + ")* (" + pp + " " + np + ")* " + np);
        this.patternMapArg1.put("verb_conj_simple1", np + " " + advp + "* " + vp2 + " " + "(" + pp + "? " + np + ")* " + comma + "* " + "(" + comma + " | <pos='CC'>) <pos='RB'>? " + advp + "*");
        this.patternMapArg1.put("statement", "<>* " + comma + " " + np + " " + vp + " " + advp + "* <string='.'>");
        this.patternMapArg1.put("list_3", "(" + np_pp + " " + comma + ")* " + np_pp + " " + comma + "? (" + and + " | " + or + ") " + np_pp);
        this.patternMapArg1.put("list_1", "(" + np + " " + comma + ")* " + np + " " + comma + "? (" + and + " | " + or + ") " + np);
        this.patternMapArg1.put("list_2", "(" + np + " " + comma + ")* " + np + " " + comma + "? (" + and + " | " + or + ") <chunk='I-NP'> (<chunk='I-NP'>)*");
        this.patternMapArg1.put("obj", "<>* " + vp + " " + pp + "? " + np_pp);
        this.patternMapArg1.put("contains_interv_clause1", np + " " + comma + " " + pp + "+ " + np + " (" + pp + "? " + np + ")* " + comma + " " + advp + "? " + vp + "? ");
        this.patternMapArg1.put("contains_interv_clause2", np + " " + comma + " " + np + " " + vp + " " + comma + " " + advp + "? " + vp + "? ");
        this.patternMapArg1.put("to_verb", " <>* <pos='TO'> <chunk='I-VP'>* <chunk='B-PRT'>? <>* ");
        this.patternMapArg1.put("subj_simple", np + " " + advp + "*");
        this.patternMapArg1.put("subj_rel", np + " " + comma + "* (<pos='WP'> | <pos='WDT'> | <string='that'>) " + advp + "*");
        this.patternMapArg1.put("subj_quotes1", "<> " + comma + "* (<string=''''> | <string='``'>) " + advp + "*");
        this.patternMapArg1.put("subj_quotes2", np + " " + comma + "* (<string=''''> | <string='``'>) " + advp + "*");
        this.patternMapArg1.put("subj_4", "(" + np + " " + vp + " " + "(" + pp + "* " + np + " (" + pp + " " + np + ")*)* " + comma + ")* " + vp + " (" + pp + "* " + np + " (" + pp + " " + np + ")*)* " + comma + "* (" + comma + " | " + and + "| " + or + ") " + advp + "*");
        this.patternMapArg1.put("subj_5a", comma + " " + pp + "* " + np + " (" + pp + "* " + np + ")* " + adjp + "* " + comma + " " + advp + "*");
        this.patternMapArg1.put("subj_5b", comma + " <pos='VBN'> (" + pp + "* " + np + ")* " + adjp + "* " + comma + " " + advp + "*");
        this.patternMapArg1.put("subj_5c", comma + " " + np + "* <pos='CC'> (" + pp + "* " + np + ")* " + adjp + "* " + comma + " " + advp + "*");
        this.patternMapArg1.put("subj_6", np + "* " + comma + " " + advp + "*");
        this.patternMapArg1.put("relative_clause", "<>* " + np + " " + comma + "? (<pos='WDT'> | <pos='WP'> | <string='that'>) " + vp + " " + pp + "? " + np_pp);
        this.patternMapArg2.put("np_list", np + " (" + comma + " " + np + ")* " + comma + " " + np + " <>*");
        this.patternMapArg2.put("np_list_cc", np + " <pos='CC'> " + np + " <>* ");
        this.patternMapArg2.put("relative_clause", vp1 + " " + pp + "? " + np_pp + " " + comma + "? " + pp + "? (<pos='WP'> | <pos='WDT'> | <pos='WRB'> | <string='that'>) <>* ");
        this.patternMapArg2.put("contains_relative_clause", "<>* <chunk='B-NP'> <>* (<string='that'> | <chunk='B-SBAR'> | <pos='WDT'> | <pos='WP'> | <pos='WRB'>) <>* ");
        this.patternMapArg2.put("contains_relative_clause2", "<>* <chunk='B-NP'> <>* (<chunk='B-SBAR'> | <pos='WDT'> | <pos='WRB'>) <>* ");
        this.patternMapArg2.put("nested_relation1", advp_vp_advp + " ((" + comma + " | <string=':'>)? (<string='``'> | <string='\"'>))? " + pp + "? " + np + " (" + pp + " " + np + ")? " + advp + "? " + vp2 + " <>*");
        this.patternMapArg2.put("nested_relation2", advp_vp_advp + " " + np + " <chunk='B-SBAR'> <>*");
        this.patternMapArg2.put("nested_relation3", advp_vp_advp + " " + pp + "? ((" + comma + " | <string=':'>)? (<string='``'> | <string='\"'>))? " + np_pp + " " + advp + "? " + vp2 + " <>*");
        this.patternMapArg2.put("nested_relation4", "<>* (<chunk='B-SBAR'> | <pos='WRB'> | <pos='WDT'> | <pos='WP'> | <string='that'>) <>* " + vp1 + " <>*");
        this.patternMapArg2.put("double_np1", np + " " + np + " <>*");
        this.patternMapArg2.put("double_np2", np + " " + np + " <chunk='B-VP'> <>*");
        this.patternMapArg2.put("infinitive_clause", advp + "? " + vp + "? <chunk='I-VP'>* <pos='TO'> <chunk='I-VP'>+ <>*");
        this.patternMapArg2.put("np_infinitive_clause", advp + "? " + vp1 + " " + advp + "? " + pp + "? ((" + comma + " | <string=':'>)? (<string='``'> | <string='\"'>))? " + np + " " + advp + "? " + vp3 + " <>*");
        this.patternMapArg2.put("complement_clause1", advp + "? " + vp1 + " (<chunk='B-SBAR'> |<pos='WRB'> | <pos='WP'>) <>*");
        this.patternMapArg2.put("complement_clause2", advp + "? " + vp1 + " " + advp + "? <string='that'> " + np + " <>*");
        this.patternMapArg2.put("objNestedClause", advp + "? " + vp1 + " " + advp + "? " + np + " <string='that'> " + np + " " + vp + " <>*");
        this.patternMapArg2.put("adj_relation", advp + "? (<pos='VBD'> | <pos='VB'> | <pos='VBZ'> | <pos='VBN'> | <pos='VBP'> | <pos='MD'>) <chunk='I-VP'>* " + advp + "? " + " <chunk='B-NP'> <chunk='I-NP'>* <chunk='B-PP'>? <chunk='B-ADJP'> <>*");
        this.patternMapArg2.put("list1", "<chunk='B-NP'> <chunk='I-NP'>* (<string=','> (<chunk='B-PP'>)? <chunk='B-NP'> <chunk='I-NP'>*)* (<string=','> | (<string=','> <pos='CC'>)) <chunk='B-NP'> <>*");
        this.patternMapArg2.put("list3", "<chunk='B-NP'> <chunk='I-NP'>* (<string=','> <chunk='B-NP'> <chunk='I-NP'>*)* <string=','>* <pos='CC'> <chunk='B-NP'> <>*");
        this.patternMapArg2.put("compound1", "<chunk='B-NP'> <chunk='I-NP'>* ((<string=','> <chunk='B-NP'> <chunk='I-NP'>* (<chunk='B-PP'>)?)* (<string=','> | (<string=','> <pos='CC'>)) <chunk='B-NP'> <chunk='I-NP'>)* <string=','>* <pos='CC'> " + advp + "? <chunk='B-VP'> <>*");
        this.patternMapArg2.put("compound2", "<chunk='B-NP'> <chunk='I-NP'>* (<chunk='B-PP'> <chunk='B-NP'> <chunk='I-NP'>)* <string=','>* <pos='CC'> " + advp + "? <chunk='B-VP'> <>*");
        this.patternMapArg2.put("ifclause1", "<chunk='B-NP'> <chunk='I-NP'>* ((<string=','> <chunk='B-NP'> <chunk='I-NP'>* (<chunk='B-PP'>)?)* (<string=','> | (<string=','> <pos='CC'>)) <chunk='B-NP'> <chunk='I-NP'>)* <string=','>* " + introduces_if + " <>*");
        this.patternMapArg2.put("ifclause2", "<chunk='B-NP'> <chunk='I-NP'>* (<chunk='B-PP'> <chunk='B-NP'> <chunk='I-NP'>)* " + introduces_if + " <>*");
        this.patternMapArg2.put("relclause1", "<chunk='I-NP'>* <string=','>? (<string='``'> | <string=''''>)? <string=','>? (<pos='WDT'> | <pos='WP'> | <string='that'>) <>* ");
        this.patternMapArg2.put("relclause2", "<chunk='I-NP'>* <string=','> <string=''''> (<pos='WDT'> | <pos='WP'> | <string='that'>) <>* ");
        this.patternMapArg2.put("relclause3", "<chunk='I-NP'>* <string=','> (<pos='WDT'> | <pos='WP'> | <string='that'>) <>* ");
        this.patternMapArg2.put("vbg_1", "<chunk='I-NP'>* <string=','> <pos='VBG'> <>* ");
        this.patternMapArg2.put("vbg_2", "<chunk='I-NP'>* <pos='VBG'> <>* ");
        this.patternMapArg2.put("app_1", "<chunk='I-NP'>* (<string='``'> | <string=''''>)? <string=','> <chunk='B-NP'> <chunk='I-NP'>* (<chunk='B-PP'>? <chunk='B-NP'> <chunk='I-NP'>*)* (<string=','> | <string='.'>) <>* ");
        this.patternMapArg2.put("app_2", "<chunk='I-NP'>* <string=','> (<string='``'> | <string=''''>)? <chunk='B-NP'> <chunk='I-NP'>* (<chunk='B-PP'>? <chunk='B-NP'> <chunk='I-NP'>*)* (<string=','> | <string='.'>) <>* ");
    }

    private void initCompiledPatternMap() {
        String pattern;
        Set<String> keys = this.patternMapArg1.keySet();
        for (String key : keys) {
            pattern = this.patternMapArg1.get(key);
            this.compiledPatternMapArg1.put(key, ChunkedSentencePattern.compile(pattern));
        }
        keys = this.patternMapArg2.keySet();
        for (String key : keys) {
            pattern = this.patternMapArg2.get(key);
            this.compiledPatternMapArg2.put(key, ChunkedSentencePattern.compile(pattern));
        }
    }

    public boolean prevStop(ChunkedExtraction extr, int current) {
        return !this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(0, extr.getStart())), "between_commas", true) && !this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(0, extr.getStart())), "between_quotes", true) && (!extr.getSentence().getPosTag(current).equals("WDT") && !extr.getSentence().getPosTag(current).equals("WRB") && !extr.getSentence().getPosTag(current).equals("WP") && this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(0, current + 1)), "double_np", true) || this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(0, current + 1)), "if", true) || this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(0, current + 1)), "verb_np", true));
    }

    public int getInterveningNPCount(ChunkedExtraction extr, int k) {
        int count = 0;
        for (int i = k + 1; i < extr.getStart(); ++i) {
            if (!extr.getSentence().getChunkTag(i).equals("B-NP") || extr.getSentence().getToken(i).equals("which") || extr.getSentence().getToken(i).equals("who") || extr.getSentence().getToken(i).equals("that")) continue;
            ++count;
        }
        return count;
    }

    public int getPunctuationCount(ChunkedExtraction extr, int current) {
        Pattern punt_pattern = Pattern.compile(PUNT);
        int punctuation_count = 0;
        for (int i = extr.getStart() - 1; i >= current; --i) {
            if (!punt_pattern.matcher(extr.getSentence().getToken(i)).matches()) continue;
            ++punctuation_count;
        }
        return punctuation_count;
    }

    public boolean getCapitalized(ChunkedExtraction extr, int current) {
        char first = extr.getSentence().getToken(current).charAt(0);
        return first > '@' && first < '[';
    }

    public boolean wordBeforePredIsConj(ChunkedExtraction extr, int current) {
        int pred_start = extr.getStart();
        return extr.getSentence().getToken(pred_start - 1).equals("but") || extr.getSentence().getToken(pred_start - 1).equals("and") || extr.getSentence().getToken(pred_start - 1).equals("or");
    }

    public boolean getInterveningConj(ChunkedExtraction extr, int current) {
        boolean intervening_and = false;
        for (int i = extr.getStart() - 1; i >= current; --i) {
            if (!extr.getSentence().getPosTag(i).equals("CC")) continue;
            intervening_and = true;
        }
        return intervening_and;
    }

    public boolean wordAfterIsVP(ChunkedExtraction extr, int current) {
        int i;
        for (i = current; i < extr.getStart() && (extr.getSentence().getChunkTag(i).contains("NP") || extr.getSentence().getChunkTag(i).contains("PP")); ++i) {
        }
        extr.getSentence().getChunkTag(i).contains("VP");
        return extr.getSentence().getChunkTag(i).contains("VP");
    }

    public boolean wordBeforeIsVP(ChunkedExtraction extr, int current) {
        int i;
        boolean word_before_vp = false;
        for (i = current; i > -1 && (extr.getSentence().getChunkTag(i).contains("NP") || extr.getSentence().getChunkTag(i).contains("PP") || extr.getSentence().getChunkTag(i).contains("RB")); --i) {
        }
        if (i > -1) {
            word_before_vp = extr.getSentence().getChunkTag(i).contains("VP") && !extr.getSentence().getChunkTag(i).contains("ADVP");
        }
        return word_before_vp;
    }

    public boolean nextIsThat(ChunkedExtraction extr, int current) {
        ++current;
        while (current < extr.getStart() && (extr.getSentence().getChunkTag(current).equals("I-NP") || extr.getSentence().getToken(current).equals(","))) {
            ++current;
        }
        if (current >= extr.getStart()) {
            return false;
        }
        return extr.getSentence().getPosTag(current).equals("WP") || extr.getSentence().getPosTag(current).equals("WDT") || extr.getSentence().getToken(current).equals("that");
    }

    public int getNPCountBefore(ChunkedExtraction extr, int current) {
        int np_count = 0;
        --current;
        while (current > -1) {
            if (extr.getSentence().getChunkTag(current).equals("B-NP")) {
                ++np_count;
            }
            --current;
        }
        return np_count;
    }

    public boolean matchesPPBeforeVerb(ChunkedExtraction extr) {
        int i = extr.getStart();
        while (i > 0 && extr.getSentence().getChunkTag(i).contains("VP")) {
            if (!extr.getSentence().getPosTag(--i).equals("IN") && !extr.getSentence().getPosTag(i).equals("TO")) continue;
            return true;
        }
        return false;
    }

    public boolean matchesToVerb(ChunkedExtraction extr, boolean debug) {
        int i = extr.getStart();
        while (i > 0 && extr.getSentence().getChunkTag(i).contains("VP")) {
            if (!extr.getSentence().getToken(--i).equals("to")) continue;
            return true;
        }
        return false;
    }

    public boolean matchesNPVerb(ChunkedExtraction extr) {
        int i = extr.getStart();
        return extr.getSentence().getChunkTag(i).contains("N");
    }

    public boolean matchesAppositiveClause2(ChunkedExtraction extr, int current) {
        if (!extr.getSentence().getChunkTag(current).equals("B-NP")) {
            return false;
        }
        int length = extr.getStart() - current;
        return this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(current, length)), "app_3", true);
    }

    public boolean matchesRelativeClause(ChunkedExtraction extr, int argend) {
        return this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(0, argend)), "relative_clause", true) && (!extr.getSentence().getChunkTag(argend - 1).contains("NP") || !extr.getSentence().getChunkTag(argend).equals("B-VP"));
    }

    public boolean matchesQuotes(ChunkedExtraction extr) {
        if (extr.getStart() < 4) {
            return false;
        }
        return extr.getSentence().getToken(extr.getStart() - 1).equals("''") && extr.getSentence().getToken(extr.getStart() - 2).equals(",");
    }

    public boolean matchesStatement(ChunkedExtraction extr) {
        if (extr.getStart() < 2) {
            return false;
        }
        int length = extr.getSentence().getLength();
        return this.matches(ChunkedSentenceToken.tokenize(extr.getSentence().getSubSequence(0, length)), "statement", true);
    }

    public boolean matchesAppositiveStrict(ChunkedExtraction extr) {
        return this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(extr.getStart(), extr.getLength())), "app_strict", true);
    }

    public boolean matchesListStrict(ChunkedExtraction extr) {
        return this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(extr.getStart(), extr.getLength())), "list_1", true) && !extr.getSentence().getSubSequence(extr.getStart(), extr.getLength()).getPosTagsAsString().contains("IN");
    }

    public boolean matchesList(ChunkedExtraction extr, int argend, int current) {
        while (current > -1 && (extr.getSentence().getChunkTag(current).contains("NP") || extr.getSentence().getChunkTag(current).contains("PP") || extr.getSentence().getPosTag(current).contains(",") || extr.getSentence().getPosTag(current).contains("CC"))) {
            int length = argend - current;
            if (!(!this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(current, length)), "list_1", true) && !this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(current, length)), "list_3", true) && !this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(current, length)), "list_2", true) || current != 0 && !extr.getSentence().getChunkTag(current).equals(",") && extr.getSentence().getChunkTag(current - 1).contains("B-VP") && extr.getSentence().getChunkTag(current - 1).contains("I-VP") || current > 1 && (extr.getSentence().getChunkTag(current - 1).contains("PP") || extr.getSentence().getChunkTag(current - 2).contains("V") || this.matchesObj(extr, current)))) {
                return true;
            }
            --current;
        }
        return false;
    }

    public boolean matchesObj(ChunkedExtraction extr, int current) {
        int length = current + 1;
        return this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(0, length)), "obj", true);
    }

    public boolean matchesCommaBeforeVerb(ChunkedExtraction extr) {
        int i = extr.getStart();
        while (i > 0 && extr.getSentence().getChunkTag(i).contains("VP")) {
            if (!extr.getSentence().getToken(--i).equals(",")) continue;
            return true;
        }
        return false;
    }

    public boolean nextNPWhich(ChunkedExtraction extr, int current) {
        int i;
        for (i = current + 1; i < extr.getStart() && !extr.getSentence().getChunkTag(i).equals("B-NP"); ++i) {
        }
        return extr.getSentence().getToken(i).equals("who") || extr.getSentence().getToken(i).equals("which") || extr.getSentence().getToken(i).equals("that");
    }

    public boolean nextIsDash(ChunkedExtraction extr, int current) {
        ++current;
        while (current < extr.getStart() && extr.getSentence().getChunkTag(current).contains("NP")) {
            ++current;
        }
        return extr.getSentence().getToken(current).equals("-");
    }

    public boolean vpStartsWithTo(ChunkedExtraction extr, int current) {
        int length = extr.getStart() - current;
        return this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(current, length)), "to_verb", true);
    }

    public boolean matchesVerbConjSimple(ChunkedExtraction extr, int current) {
        return this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(current, extr.getStart() - current)), "verb_conj_simple1", true);
    }

    public boolean matchesAppositiveClause(ChunkedExtraction extr, int current) {
        int i;
        boolean notseencomma = true;
        for (i = current - 1; i > 0 && (notseencomma || !extr.getSentence().getChunkTag(i).equals("B-NP")); --i) {
            if (!extr.getSentence().getToken(i).equals(",")) continue;
            notseencomma = false;
        }
        if (i < 0 || notseencomma || !extr.getSentence().getChunkTag(i).equals("B-NP")) {
            return false;
        }
        int length = extr.getStart() - i;
        return this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(i, length)), "app_1", true) || this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(i, length)), "app_2", true);
    }

    public boolean simpleSubj(ChunkedExtraction extr, int i) {
        return !extr.getSentence().getPosTag(i).startsWith("W") && this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(i, extr.getStart() - i)), "subj_simple", true);
    }

    public boolean quotesSubj(ChunkedExtraction extr, int i) {
        return this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(i, extr.getStart() - i)), "subj_quotes1", true) || this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(i, extr.getStart() - i)), "subj_quotes2", true);
    }

    public boolean relSubj(ChunkedExtraction extr, int i) {
        return this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(i, extr.getStart() - i)), "subj_rel", true);
    }

    public boolean findSubj(ChunkedExtraction extr, int i) {
        int npcount = 0;
        for (int index = i + 1; index < extr.getStart(); ++index) {
            if (!extr.getSentence().getChunkTag(index).equals("B-NP")) continue;
            ++npcount;
        }
        while (i > -1) {
            int start = i;
            int length = extr.getStart() - i;
            if (this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(start, length)), "subj_4", true) || extr.getSentence().getPosTag(extr.getStart()).equals("VBN") && this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(start, length)), "subj_6", true) || npcount < 1 && this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(start, length)), "subj_5a", true) || this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(start, length)), "subj_5b", true) || this.matches(ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(start, length)), "subj_5c", true)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public boolean appClause(ChunkedExtraction extr, int current) {
        List<ChunkedSentenceToken> tocheck = ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(current, extr.getSentence().getLength() - current));
        return this.matches(tocheck, "app_1", false) || this.matches(tocheck, "app_2", false);
    }

    public boolean vbgIsNext(ChunkedExtraction extr, int current) {
        List<ChunkedSentenceToken> tocheck = ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(current, extr.getSentence().getLength() - current));
        return this.matches(tocheck, "vbg_1", false) || this.matches(tocheck, "vbg_2", false);
    }

    public boolean relClause(ChunkedExtraction extr, int current) {
        List<ChunkedSentenceToken> tocheck = ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(current, extr.getSentence().getLength() - current));
        return this.matches(tocheck, "relclause1", false) || this.matches(tocheck, "relclause2", false) || this.matches(tocheck, "relclause3", false);
    }

    public boolean ifClause(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPredEnd(extr);
        return this.matches(tocheck, "ifclause1", false) || this.matches(tocheck, "ifclause2", false);
    }

    public boolean compoundVerb(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPredEnd(extr);
        return this.matches(tocheck, "compound1", false) || this.matches(tocheck, "compound2", false);
    }

    public boolean startsList(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPredEnd(extr);
        return this.matches(tocheck, "list1", false) || this.matches(tocheck, "list3", false);
    }

    public boolean adjRelation(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPred(extr);
        return this.matches(tocheck, "adj_relation", false);
    }

    public boolean objNestedClause(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPred(extr);
        return this.matches(tocheck, "objNestedClause", false);
    }

    public boolean complementClause(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPred(extr);
        return this.matches(tocheck, "complement_clause1", false) || this.matches(tocheck, "complement_clause2", false);
    }

    public boolean npInfinitiveClause(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPred(extr);
        return this.matches(tocheck, "np_infinitive_clause", false);
    }

    public boolean infinitiveClause(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPred(extr);
        return this.matches(tocheck, "infinitive_clause", false);
    }

    public boolean doubleNP(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPredEnd(extr);
        return this.matches(tocheck, "double_np1", false) && !this.matches(tocheck, "double_np2", false);
    }

    public boolean nestedRelation1(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPred(extr);
        if (this.matches(tocheck, "nested_relation1", false)) {
            int count = 0;
            for (int i = extr.getStart(); i < extr.getStart() + extr.getLength(); ++i) {
                if (!extr.getSentence().getPosTag(i).startsWith("V") && !extr.getSentence().getChunkTag(i).equals("B-NP")) continue;
                ++count;
            }
            if (count < 2) {
                return true;
            }
        }
        return false;
    }

    public boolean nestedRelation2(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPred(extr);
        if (this.matches(tocheck, "nested_relation2", false)) {
            return true;
        }
        if (this.matches(tocheck, "nested_relation1", false) && !this.complementClause(extr)) {
            int count = 0;
            for (int i = extr.getStart(); i < extr.getStart() + extr.getLength(); ++i) {
                if (!extr.getSentence().getPosTag(i).startsWith("V") && !extr.getSentence().getChunkTag(i).equals("B-NP")) continue;
                ++count;
            }
            if (count >= 2) {
                return true;
            }
        }
        return false;
    }

    public boolean npRelativeClause(ChunkedExtraction extr) {
        List<ChunkedSentenceToken> tocheck = PatternExtractor.getChunkedSentenceFromPred(extr);
        return this.matches(tocheck, "relative_clause", false);
    }

    public boolean matchesNPList(ChunkedExtraction extr) {
        boolean innplist = false;
        int pred_end = extr.getStart() + extr.getLength();
        int start = -1;
        for (int i = pred_end; i < extr.getSentence().getLength(); ++i) {
            if (!extr.getSentence().getChunkTag(i).equals("B-NP")) continue;
            start = i;
            break;
        }
        if (start < 0) {
            return false;
        }
        int length = extr.getSentence().getLength() - start;
        List<ChunkedSentenceToken> tocheck = ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(start, length));
        boolean matches1 = this.matches(tocheck, "np_list", false);
        boolean matches2 = this.matches(tocheck, "np_list_cc", false);
        if (matches1 || matches2) {
            innplist = true;
        }
        return innplist;
    }

    public static List<ChunkedSentenceToken> getChunkedSentenceFromPred(ChunkedExtraction extr) {
        int pred_start_orig;
        int start = pred_start_orig = extr.getStart();
        for (int i = pred_start_orig; i < pred_start_orig + extr.getLength(); ++i) {
            if (!extr.getSentence().getChunkTag(i).contains("I-VP") && !extr.getSentence().getChunkTag(i).contains("B-VP")) continue;
            start = i;
        }
        int end = extr.getSentence().getLength();
        return ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(start, end - start));
    }

    public static List<ChunkedSentenceToken> getChunkedSentenceFromPredEnd(ChunkedExtraction extr) {
        int start = extr.getStart() + extr.getLength();
        int end = extr.getSentence().getLength();
        return ChunkedSentenceToken.tokenize(extr.getSentence(), new Range(start, end - start));
    }

    public boolean matches(List<ChunkedSentenceToken> tokens, String type, boolean arg1) {
        Match match = arg1 ? this.compiledPatternMapArg1.get(type).match(tokens) : this.compiledPatternMapArg2.get(type).match(tokens);
        return match != null;
    }

    public static boolean inNPList(ChunkedExtraction extr, int current) {
        int pred_end = extr.getStart() + extr.getLength();
        int start = -1;
        for (int i = pred_end; i < extr.getSentence().getLength(); ++i) {
            if (!extr.getSentence().getChunkTag(i).equals("B-NP")) continue;
            start = i;
            break;
        }
        if (start < 0 || start > current - 1) {
            return false;
        }
        int comma_cc_count = 0;
        for (int i = start; i < current + 1; ++i) {
            if (extr.getSentence().getToken(i).equals("which") || extr.getSentence().getToken(i).equals("that") || extr.getSentence().getToken(i).equals("who") || !extr.getSentence().getChunkTag(i).equals("B-NP") && !extr.getSentence().getChunkTag(i).equals("I-NP") && !extr.getSentence().getToken(i).equals("and") && !extr.getSentence().getToken(i).equals("or") && !extr.getSentence().getToken(i).equals(",")) {
                return false;
            }
            if (!extr.getSentence().getToken(i).equals("and") && !extr.getSentence().getToken(i).equals("or") && !extr.getSentence().getToken(i).equals(",")) continue;
            ++comma_cc_count;
        }
        return comma_cc_count > 0;
    }

    public static boolean inPPList(ChunkedExtraction extr, int current) {
        int pred_end = extr.getStart() + extr.getLength();
        int start = -1;
        for (int i = pred_end; i < extr.getSentence().getLength(); ++i) {
            if (!extr.getSentence().getChunkTag(i).equals("B-NP")) continue;
            start = i;
            break;
        }
        if (start < 0 || start > current - 1) {
            return false;
        }
        int pp_count = 0;
        for (int i = start; i < current + 1; ++i) {
            if (extr.getSentence().getToken(i).equals("which") || extr.getSentence().getToken(i).equals("that") || extr.getSentence().getToken(i).equals("who") || !extr.getSentence().getChunkTag(i).equals("B-NP") && !extr.getSentence().getChunkTag(i).equals("I-NP") && !extr.getSentence().getChunkTag(i).equals("B-PP") && !extr.getSentence().getChunkTag(i).equals("I-PP")) {
                return false;
            }
            if (!extr.getSentence().getChunkTag(i).equals("B-PP")) continue;
            ++pp_count;
        }
        return pp_count > 0;
    }

    public static boolean previousIsOf(ChunkedExtraction extr, int current) {
        --current;
        while (current > extr.getStart() + extr.getLength() && !extr.getSentence().getChunkTag(current).contains("NP") && !extr.getSentence().getChunkTag(current).contains("VP")) {
            if (extr.getSentence().getToken(current).equals("of")) {
                return true;
            }
            --current;
        }
        return false;
    }

    public static boolean nextIsVP(ChunkedExtraction extr, int current) {
        int next = -1;
        for (int i = current + 1; i < extr.getSentence().getLength(); ++i) {
            if (extr.getSentence().getChunkTag(i).equals("I-NP")) continue;
            next = i;
            break;
        }
        return next > -1 && next < extr.getSentence().getLength() && (extr.getSentence().getPosTag(next).contains("V") || extr.getSentence().getChunkTag(next).contains("V"));
    }

    public static boolean nextIsPP(ChunkedExtraction extr, int current) {
        int next = -1;
        for (int i = current + 1; i < extr.getSentence().getLength(); ++i) {
            if (extr.getSentence().getChunkTag(i).equals("I-NP")) continue;
            next = i;
            break;
        }
        return next > -1 && next < extr.getSentence().getLength() && extr.getSentence().getChunkTag(next).contains("PP");
    }

    public static boolean nextisNP(ChunkedExtraction extr, int current) {
        int next = -1;
        for (int i = current + 1; i < extr.getSentence().getLength(); ++i) {
            if (extr.getSentence().getChunkTag(i).equals("I-NP")) continue;
            next = i;
            break;
        }
        return next > -1 && next < extr.getSentence().getLength() && extr.getSentence().getChunkTag(next).contains("B-NP");
    }

    public static int getNPToEndCount(ChunkedExtraction extr, int current) {
        int count = 0;
        for (int i = current; i < extr.getSentence().getLength(); ++i) {
            if (!extr.getSentence().getChunkTag(i).equals("B-NP")) continue;
            ++count;
        }
        return count;
    }
}

