/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor;

import com.google.common.base.Joiner;
import edu.washington.cs.knowitall.extractor.ChunkedArgumentExtractor;
import edu.washington.cs.knowitall.extractor.ReVerbRelationExtractor;
import edu.washington.cs.knowitall.extractor.conf.ReVerbOpenNlpConfFunction;
import edu.washington.cs.knowitall.extractor.mapper.ReVerbArgument1Mappers;
import edu.washington.cs.knowitall.extractor.mapper.ReVerbArgument2Mappers;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.ChunkedSentenceReader;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import edu.washington.cs.knowitall.util.DefaultObjects;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;

public class ReVerbExtractor
extends ReVerbRelationExtractor {
    public ReVerbExtractor() {
    }

    public ReVerbExtractor(int minFreq, boolean useLexSynConstraints, boolean mergeOverlapRels, boolean allowUnary) {
        super(minFreq, useLexSynConstraints, mergeOverlapRels, allowUnary);
    }

    @Override
    protected void initializeArgumentExtractors() {
        ChunkedArgumentExtractor arg1Extr = new ChunkedArgumentExtractor(ChunkedArgumentExtractor.Mode.LEFT);
        arg1Extr.addMapper(new ReVerbArgument1Mappers());
        this.setArgument1Extractor(arg1Extr);
        ChunkedArgumentExtractor arg2Extr = new ChunkedArgumentExtractor(ChunkedArgumentExtractor.Mode.RIGHT);
        arg2Extr.addMapper(new ReVerbArgument2Mappers());
        this.setArgument2Extractor(arg2Extr);
    }

    public static void main(String[] args) throws Exception {
        BufferedReader reader = args.length == 0 ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(args[0]));
        int sentenceCount = 0;
        int extractionCount = 0;
        System.err.print("Initializing extractor...");
        ReVerbExtractor extractor = new ReVerbExtractor();
        System.err.println("Done.");
        System.err.print("Initializing confidence function...");
        ReVerbOpenNlpConfFunction scoreFunc = new ReVerbOpenNlpConfFunction();
        System.err.println("Done.");
        System.err.print("Initializing NLP tools...");
        ChunkedSentenceReader sentReader = DefaultObjects.getDefaultSentenceReader(reader);
        System.err.println("Done.");
        Joiner joiner = Joiner.on((String)"\t");
        for (ChunkedSentence sent : sentReader.getSentences()) {
            String sentString = sent.getTokensAsString();
            System.out.println(String.format("sentence\t%s\t%s", ++sentenceCount, sentString));
            for (ChunkedBinaryExtraction extr : extractor.extract(sent)) {
                double score = scoreFunc.getConf(extr);
                String arg1 = extr.getArgument1().toString();
                String rel = extr.getRelation().toString();
                String arg2 = extr.getArgument2().toString();
                String extrString = joiner.join((Object)sentenceCount, (Object)arg1, new Object[]{rel, arg2, score});
                System.out.println("extraction\t" + extrString);
                ++extractionCount;
            }
        }
        System.err.println(String.format("Got %s extractions from %s sentences.", extractionCount, sentenceCount));
    }
}

