/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunctionException;
import edu.washington.cs.knowitall.extractor.conf.HypotheticalFeatures;
import edu.washington.cs.knowitall.extractor.conf.NestedFeatures;
import edu.washington.cs.knowitall.extractor.conf.featureset.BooleanFeatureSet;
import edu.washington.cs.knowitall.extractor.conf.featureset.ChunkFeature;
import edu.washington.cs.knowitall.extractor.conf.featureset.PosFeature;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.ChunkedSentencePattern;
import edu.washington.cs.knowitall.nlp.ChunkedSentenceToken;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import edu.washington.cs.knowitall.regex.Match;
import edu.washington.cs.knowitall.regex.RegularExpression;
import edu.washington.cs.knowitall.sequence.LayeredTokenMatcher;
import edu.washington.cs.knowitall.sequence.LayeredTokenPattern;
import edu.washington.cs.knowitall.sequence.SequenceException;
import java.util.HashMap;
import java.util.List;

public class ReVerbFeatures {
    private HashMap<String, Predicate<ChunkedBinaryExtraction>> featureMap;
    private BooleanFeatureSet<ChunkedBinaryExtraction> featureSet;
    private String VERB = "RB_pos? [MD_pos VB_pos VBD_pos VBP_pos VBZ_pos VBG_pos VBN_pos] RP_pos? RB_pos?";
    private String WORD = "[$_pos PRP$_pos CD_pos DT_pos JJ_pos JJS_pos JJR_pos NN_pos NNS_pos NNP_pos NNPS_pos POS_pos PRP_pos RB_pos RBR_pos RBS_pos VBN_pos VBG_pos]";
    private String PREP = "RB_pos? [IN_pos TO_pos RP_pos] RB_pos?";
    private String list1 = "<chunk='B-NP'> <chunk='I-NP'>* (<string=','> (<chunk='B-PP'>)? <chunk='B-NP'> <chunk='I-NP'>*)+ (<string=','> | (<string=','> <pos='CC'>)) <chunk='B-NP'> <chunk='I-NP'>*";
    private String list2 = "<chunk='B-NP'> <chunk='I-NP'>* (<string=','> <chunk='B-NP'> <chunk='I-NP'>*)+ <string=','>* <pos='CC'> <chunk='B-NP'> <chunk='I-NP'>*";
    public RegularExpression<ChunkedSentenceToken> listPattern1 = ChunkedSentencePattern.compile(this.list1);
    public RegularExpression<ChunkedSentenceToken> listPattern2 = ChunkedSentencePattern.compile(this.list2);

    public ReVerbFeatures() throws ConfidenceFunctionException {
        try {
            this.initFeatureSet();
        }
        catch (SequenceException e) {
            throw new ConfidenceFunctionException("Unable to initialize features", e);
        }
    }

    public BooleanFeatureSet<ChunkedBinaryExtraction> getFeatureSet() {
        return this.featureSet;
    }

    private void initFeatureSet() throws SequenceException {
        this.initFeatureMap();
        this.featureSet = new BooleanFeatureSet(this.featureMap);
    }

    private void initFeatureMap() throws SequenceException {
        this.featureMap = new HashMap();
        this.featureMap.put("sent starts w/arg1", this.startArg1());
        this.featureMap.put("sent ends w/arg2", this.endArg2());
        this.featureMap.put("which|who|that before rel", this.relPronounBeforeRel());
        this.featureMap.put("arg2 is proper", this.arg2IsProper());
        this.featureMap.put("arg1 is proper", this.arg1IsProper());
        this.featureMap.put("rel is VW+P", this.relIsVWP());
        this.featureMap.put("rel ends with to", this.relEndsWithToken("to"));
        this.featureMap.put("rel ends with in", this.relEndsWithToken("in"));
        this.featureMap.put("rel ends with for", this.relEndsWithToken("for"));
        this.featureMap.put("rel ends with of", this.relEndsWithToken("of"));
        this.featureMap.put("rel ends with on", this.relEndsWithToken("on"));
        this.featureMap.put("extr covers phrase", this.extrCoversPhrase());
        this.featureMap.put("arg2 part of a list", this.arg2InList());
        this.featureMap.put("np before arg1", ChunkFeature.rightBeforeArg1("B-NP", "I-NP"));
        this.featureMap.put("rel contains vbz", PosFeature.withinRel("VBZ"));
        this.featureMap.put("rel contains vbg", PosFeature.withinRel("VBG"));
        this.featureMap.put("rel contains vbd", PosFeature.withinRel("VBD"));
        this.featureMap.put("rel contains vbn", PosFeature.withinRel("VBN"));
        this.featureMap.put("rel contains vbp", PosFeature.withinRel("VBP"));
        this.featureMap.put("rel contains vb", PosFeature.withinRel("VB"));
        this.featureMap.put("conj before rel", PosFeature.rightBeforeRel("CC"));
        this.featureMap.put("prep before arg1", PosFeature.rightBeforeArg1("IN", "TO"));
        this.featureMap.put("verb after arg2", PosFeature.rightAfterArg2(PosFeature.allVerbPosTags));
        this.featureMap.put("np after arg2", ChunkFeature.rightAfterArg2("B-NP", "I-NP"));
        this.featureMap.put("prep after arg2", PosFeature.rightAfterArg2("IN", "TO"));
        this.featureMap.put("arg2 contains pronoun", PosFeature.withinArg2("PRP"));
        this.featureMap.put("arg1 contains pronoun", PosFeature.withinArg1("PRP"));
        this.featureMap.put("arg2 contains pos pronoun", PosFeature.withinArg2("PRP$"));
        this.featureMap.put("arg2 contains pos pronoun", PosFeature.withinArg2("PRP$"));
        this.featureMap.put("rel is a single verb", PosFeature.relSingleVerb());
        this.featureMap.put("if before arg1", this.tokenBeforeArg1("if"));
        this.featureMap.put("in before arg1", this.tokenBeforeArg1("in"));
        this.featureMap.put("that before rel", this.tokenBeforeRel("that"));
        this.featureMap.put("to after arg2", this.tokenAfterArg2("to"));
        this.featureMap.put("that after arg2", this.tokenAfterArg2("that"));
        this.featureMap.put("3F", new Predicate<ChunkedBinaryExtraction>(){
            Predicate<ChunkedBinaryExtraction> startArg1;
            Predicate<ChunkedBinaryExtraction> endArg2;
            Predicate<ChunkedBinaryExtraction> extrCoversPhrase;
            {
                this.startArg1 = ReVerbFeatures.this.startArg1();
                this.endArg2 = ReVerbFeatures.this.endArg2();
                this.extrCoversPhrase = ReVerbFeatures.this.extrCoversPhrase();
            }

            public boolean apply(ChunkedBinaryExtraction arg0) {
                return this.startArg1.apply((Object)arg0) && this.endArg2.apply((Object)arg0) && this.extrCoversPhrase.apply((Object)arg0);
            }
        });
        this.featureMap.putAll(new NestedFeatures().getFeatureMap());
        this.featureMap.putAll(new HypotheticalFeatures().getFeatureMap());
    }

    private Predicate<ChunkedBinaryExtraction> arg2InList() {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction extr) {
                Range matchRange;
                ChunkedArgumentExtraction arg2 = extr.getArgument2();
                ChunkedSentence sentence = arg2.getSentence();
                List matchList = ReVerbFeatures.this.listPattern2.findAll(ChunkedSentenceToken.tokenize(sentence));
                for (Match match : matchList) {
                    matchRange = new Range(match.startIndex(), match.endIndex() - match.startIndex());
                    if (!matchRange.overlapsWith(arg2.getRange())) continue;
                    return true;
                }
                matchList = ReVerbFeatures.this.listPattern1.findAll(ChunkedSentenceToken.tokenize(sentence));
                for (Match match : matchList) {
                    matchRange = new Range(match.startIndex(), match.endIndex() - match.startIndex());
                    if (!matchRange.overlapsWith(arg2.getRange())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private Predicate<ChunkedBinaryExtraction> startArg1() {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                return e.getArgument1().getRange().getStart() == 0;
            }
        };
    }

    private Predicate<ChunkedBinaryExtraction> endArg2() {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                int sentEnd;
                int arg2End = e.getArgument2().getRange().getLastIndex();
                return arg2End == (sentEnd = e.getSentence().getLength() - 2);
            }
        };
    }

    private Predicate<ChunkedBinaryExtraction> relPronounBeforeRel() {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                String precToken;
                ChunkedExtraction pred = e.getRelation();
                int predStart = pred.getStart();
                return predStart > 0 && ((precToken = ((String)e.getSentence().getTokens().get(predStart - 1)).toLowerCase()).equals("which") || precToken.equals("who") || precToken.equals("that"));
            }
        };
    }

    private boolean isProperNp(ChunkedExtraction e) {
        for (String tag : e.getPosTags()) {
            if (!tag.equalsIgnoreCase("NNP") && !tag.equalsIgnoreCase("NNPS")) continue;
            return true;
        }
        return false;
    }

    private Predicate<ChunkedBinaryExtraction> arg1IsProper() {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                return ReVerbFeatures.this.isProperNp(e.getArgument1());
            }
        };
    }

    private Predicate<ChunkedBinaryExtraction> arg2IsProper() {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                return ReVerbFeatures.this.isProperNp(e.getArgument2());
            }
        };
    }

    public Predicate<ChunkedBinaryExtraction> relIsOneVerb() {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                ChunkedExtraction rel = e.getRelation();
                ImmutableList<String> posTags = rel.getPosTags();
                return posTags.size() == 1 && ((String)posTags.get(0)).startsWith("V");
            }
        };
    }

    private Predicate<ChunkedBinaryExtraction> relIsVWP() throws SequenceException {
        String patternStr = String.format("(%s (%s+ (%s)+))+", this.VERB, this.WORD, this.PREP);
        final LayeredTokenPattern pattern = new LayeredTokenPattern(patternStr);
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                try {
                    LayeredTokenMatcher m = pattern.matcher(e.getRelation());
                    int n = 0;
                    while (m.find()) {
                        ++n;
                    }
                    return n == 1;
                }
                catch (SequenceException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        };
    }

    private Predicate<ChunkedBinaryExtraction> relEndsWithToken(String t) {
        final String token = t;
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                ImmutableList<String> tokens = e.getRelation().getTokens();
                return ((String)tokens.get(tokens.size() - 1)).equals(token);
            }
        };
    }

    private Predicate<ChunkedBinaryExtraction> extrCoversPhrase() {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                ChunkedSentence sent = e.getSentence();
                ImmutableList<String> tokens = sent.getTokens();
                Range x = e.getArgument1().getRange();
                Range y = e.getArgument2().getRange();
                Range r = e.getRelation().getRange();
                boolean adj = x.isAdjacentTo(r) && r.isAdjacentTo(y);
                int xs = x.getStart();
                boolean leftOk = xs == 0 || ((String)tokens.get(xs - 1)).equals(",") || ((String)tokens.get(xs - 1)).equals(".");
                int l = sent.getLength() - 1;
                int yr = y.getLastIndex();
                boolean rightOk = yr == l || ((String)tokens.get(yr + 1)).equals(",") || ((String)tokens.get(yr + 1)).equals(".");
                return adj && leftOk && rightOk;
            }
        };
    }

    private Predicate<ChunkedBinaryExtraction> tokenBeforeArg1(final String token) {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                String precTok;
                ChunkedArgumentExtraction arg1 = e.getArgument1();
                int arg1Start = arg1.getStart();
                return arg1Start > 0 && (precTok = (String)e.getSentence().getTokens().get(arg1Start - 1)).equalsIgnoreCase(token);
            }
        };
    }

    private Predicate<ChunkedBinaryExtraction> tokenBeforeRel(final String token) {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                String precTok;
                ChunkedExtraction rel = e.getRelation();
                int relStart = rel.getStart();
                return relStart > 0 && (precTok = (String)e.getSentence().getTokens().get(relStart - 1)).equalsIgnoreCase(token);
            }
        };
    }

    private Predicate<ChunkedBinaryExtraction> tokenAfterArg2(final String token) {
        return new Predicate<ChunkedBinaryExtraction>(){

            public boolean apply(ChunkedBinaryExtraction e) {
                String nextTok;
                ChunkedArgumentExtraction arg2 = e.getArgument2();
                int arg1End = arg2.getStart() + arg2.getLength() - 1;
                return arg1End + 1 < e.getSentence().getLength() - 1 && (nextTok = (String)e.getSentence().getTokens().get(arg1End + 1)).equalsIgnoreCase(token);
            }
        };
    }
}

