/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf;

import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunction;
import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunctionException;
import edu.washington.cs.knowitall.extractor.conf.ReVerbFeatures;
import edu.washington.cs.knowitall.extractor.conf.classifier.LogisticRegression;
import edu.washington.cs.knowitall.extractor.conf.featureset.BooleanFeatureSet;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ReVerbIndependentConfFunction
implements ConfidenceFunction {
    private ReVerbFeatures reverbFeatures;
    private BooleanFeatureSet<ChunkedBinaryExtraction> featureSet;
    private final LogisticRegression<ChunkedBinaryExtraction> logreg;

    public ReVerbIndependentConfFunction(URL modelUrl) {
        try {
            this.reverbFeatures = new ReVerbFeatures();
            this.featureSet = this.reverbFeatures.getFeatureSet();
            this.logreg = new LogisticRegression<ChunkedBinaryExtraction>(this.featureSet, modelUrl.openStream());
        }
        catch (IOException e) {
            throw new ConfidenceFunctionException("Unable to load classifier: " + modelUrl, e);
        }
    }

    public ReVerbIndependentConfFunction(File modelFile) throws MalformedURLException {
        this(modelFile.toURI().toURL());
    }

    public ReVerbIndependentConfFunction(String modelResourceName) {
        this(ReVerbIndependentConfFunction.class.getClassLoader().getResource(modelResourceName));
    }

    @Override
    public double getConf(ChunkedBinaryExtraction extr) throws ConfidenceFunctionException {
        try {
            return this.logreg.confidence(extr);
        }
        catch (Exception e) {
            throw new ConfidenceFunctionException(e);
        }
    }
}

