/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf;

import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunction;
import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunctionException;
import edu.washington.cs.knowitall.extractor.conf.ReVerbFeatures;
import edu.washington.cs.knowitall.extractor.conf.featureset.BooleanFeatureSet;
import edu.washington.cs.knowitall.extractor.conf.opennlp.OpenNlpConfFunction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.PlainTextGISModelReader;

public class ReVerbOpenNlpConfFunction
implements ConfidenceFunction {
    private ReVerbFeatures reverbFeatures;
    private OpenNlpConfFunction<ChunkedBinaryExtraction> conf;

    public ReVerbOpenNlpConfFunction() throws ConfidenceFunctionException, IOException {
        this("reverb-conf-maxent.gz");
    }

    public ReVerbOpenNlpConfFunction(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            GISModel model;
            try {
                model = (GISModel)new PlainTextGISModelReader(new BufferedReader(new InputStreamReader(new GZIPInputStream(is)))).getModel();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.initializeConfFunction(model);
        }
        catch (IOException e) {
            throw new ConfidenceFunctionException("Unable to load classifier: " + url, e);
        }
        finally {
            is.close();
        }
    }

    public ReVerbOpenNlpConfFunction(String modelResourcePath) throws IOException {
        this(ReVerbOpenNlpConfFunction.class.getClassLoader().getResource(modelResourcePath));
    }

    public ReVerbOpenNlpConfFunction(File modelFile) throws IOException {
        this(modelFile.toURI().toURL());
    }

    private void initializeConfFunction(GISModel model) throws IOException {
        this.reverbFeatures = new ReVerbFeatures();
        BooleanFeatureSet<ChunkedBinaryExtraction> featureSet = this.reverbFeatures.getFeatureSet();
        this.conf = new OpenNlpConfFunction<ChunkedBinaryExtraction>(model, featureSet);
    }

    @Override
    public double getConf(ChunkedBinaryExtraction extr) throws ConfidenceFunctionException {
        return this.conf.getConf(extr);
    }
}

