/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf.classifier;

import edu.washington.cs.knowitall.extractor.conf.featureset.FeatureSet;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class LogisticRegression<E> {
    private final FeatureSet<E> featureSet;
    private final Map<String, Double> featureWeights;
    private final double intercept;

    public LogisticRegression(FeatureSet<E> featureSet, Map<String, Double> weights) {
        this.featureSet = featureSet;
        this.featureWeights = weights;
        this.intercept = this.featureWeights.get("intercept");
    }

    public LogisticRegression(FeatureSet<E> featureSet, InputStream input) throws FileNotFoundException {
        this(featureSet, LogisticRegression.buildFeatureWeightMap(input));
    }

    public static Map<String, Double> buildFeatureWeightMap(InputStream input) throws FileNotFoundException {
        HashMap<String, Double> featureWeights = new HashMap<String, Double>();
        Scanner scan = new Scanner(input);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            String[] parts = line.split("(?:    \\s*)|\\t\\s*");
            String featureName = parts[0];
            Double weight = Double.parseDouble(parts[1]);
            featureWeights.put(featureName.toLowerCase(), weight);
        }
        return featureWeights;
    }

    public double confidence(E extraction) {
        double z = this.intercept;
        for (String featureName : this.featureSet.getFeatureNames()) {
            if (!this.featureWeights.containsKey(featureName)) continue;
            double weight = this.featureWeights.get(featureName);
            double feature = this.featureSet.featurize(featureName, extraction);
            z += weight * feature;
        }
        return 1.0 / (1.0 + Math.exp(-z));
    }
}

