/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf.opennlp;

import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunctionException;
import edu.washington.cs.knowitall.extractor.conf.featureset.BooleanFeatureSet;
import edu.washington.cs.knowitall.extractor.conf.opennlp.OpenNlpAlphabet;
import java.io.IOException;
import opennlp.maxent.GISModel;

public class OpenNlpConfFunction<E> {
    private BooleanFeatureSet<E> featureSet;
    private GISModel model;
    private OpenNlpAlphabet<E> alphabet;

    public OpenNlpConfFunction(GISModel model, BooleanFeatureSet<E> featureSet) throws IOException {
        this.model = model;
        this.featureSet = featureSet;
        this.alphabet = new OpenNlpAlphabet<E>(this.featureSet);
    }

    public String[] featurize(E extr) {
        String[] stringFeatures = new String[this.featureSet.getNumFeatures()];
        int i = 0;
        for (String feature : this.featureSet.getFeatureNames()) {
            boolean value = this.featureSet.featurizeToBool(feature, extr);
            stringFeatures[i++] = (String)this.alphabet.lookup.get((Object)new OpenNlpAlphabet.Key(feature, value));
        }
        return stringFeatures;
    }

    public double getConf(E extr) throws ConfidenceFunctionException {
        int i = 0;
        while (!this.model.getOutcome(i).equals("1")) {
            ++i;
        }
        return this.model.eval(this.featurize(extr))[i];
    }
}

