/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import edu.washington.cs.knowitall.extractor.mapper.FilterMapper;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;

public class ChunkedBinaryExtractionStringLengthFilter
extends FilterMapper<ChunkedBinaryExtraction> {
    private int minArgLength = 0;
    private int maxArgLength = Integer.MAX_VALUE;
    private int minPredicateLength = 0;
    private int maxPredicateLength = Integer.MAX_VALUE;

    public ChunkedBinaryExtractionStringLengthFilter(int minArgLength, int maxArgLength, int minPredicateLength, int maxPredicateLength) {
        this.minArgLength = minArgLength;
        this.maxArgLength = maxArgLength;
        this.minPredicateLength = minPredicateLength;
        this.maxPredicateLength = maxPredicateLength;
    }

    @Override
    public boolean doFilter(ChunkedBinaryExtraction extraction) {
        String arg1 = extraction.getArgument1().getTokensAsString();
        String arg2 = extraction.getArgument2().getTokensAsString();
        String predicate = extraction.getRelation().getTokensAsString();
        return arg1.length() >= this.minArgLength && arg1.length() <= this.maxArgLength && arg2.length() >= this.minArgLength && arg2.length() <= this.maxArgLength && predicate.length() >= this.minPredicateLength && predicate.length() <= this.maxPredicateLength;
    }
}

