/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import com.google.common.collect.Iterables;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.extractor.mapper.Mapper;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MergeOverlappingMapper
extends Mapper<ChunkedExtraction> {
    public static List<Range> mergeOverlapping(List<Range> ranges) {
        Collections.sort(ranges, Range.getStartComparator());
        ArrayList<Range> result = new ArrayList<Range>(ranges.size());
        if (ranges.size() > 1) {
            result.add(ranges.get(0));
            for (int i = 1; i < ranges.size(); ++i) {
                Range curr = ranges.get(i);
                Range prev = (Range)result.get(result.size() - 1);
                if (prev.isAdjacentOrOverlaps(curr)) {
                    Range updated = curr.join(prev);
                    result.set(result.size() - 1, updated);
                    continue;
                }
                result.add(curr);
            }
            return result;
        }
        return ranges;
    }

    @Override
    protected Iterable<ChunkedExtraction> doMap(Iterable<ChunkedExtraction> extrs) {
        ArrayList<ChunkedExtraction> extrList = new ArrayList<ChunkedExtraction>();
        Iterables.addAll(extrList, extrs);
        if (extrList.size() > 1) {
            ChunkedSentence sent = ((ChunkedExtraction)extrList.get(0)).getSentence();
            ArrayList<Range> ranges = new ArrayList<Range>(extrList.size());
            for (ChunkedExtraction e : extrList) {
                ranges.add(e.getRange());
            }
            List<Range> mergedRanges = MergeOverlappingMapper.mergeOverlapping(ranges);
            ArrayList<ChunkedExtraction> result = new ArrayList<ChunkedExtraction>(mergedRanges.size());
            for (Range r : mergedRanges) {
                ChunkedExtraction extr = new ChunkedExtraction(sent, r);
                result.add(extr);
            }
            return result;
        }
        return extrList;
    }
}

