/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import edu.washington.cs.knowitall.extractor.mapper.AdjacentToRelationFilter;
import edu.washington.cs.knowitall.extractor.mapper.ClosestArgumentMapper;
import edu.washington.cs.knowitall.extractor.mapper.FilterMapper;
import edu.washington.cs.knowitall.extractor.mapper.MapperList;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;

public class ReVerbArgument2Mappers
extends MapperList<ChunkedArgumentExtraction> {
    public ReVerbArgument2Mappers() {
        this.init();
    }

    private void init() {
        this.addFirstPosTagNotEqualsFilter("WDT");
        this.addFirstPosTagNotEqualsFilter("WP$");
        this.addFirstPosTagNotEqualsFilter("WP");
        this.addFirstPosTagNotEqualsFilter("WRB");
        this.addFirstTokenNotEqualsFilter("which");
        this.addMapper(new ClosestArgumentMapper());
        this.addMapper(new AdjacentToRelationFilter());
    }

    private void addFirstPosTagNotEqualsFilter(String posTag) {
        final String posTagCopy = posTag;
        this.addMapper(new FilterMapper<ChunkedArgumentExtraction>(){

            @Override
            public boolean doFilter(ChunkedArgumentExtraction extr) {
                return !((String)extr.getPosTags().get(0)).equals(posTagCopy);
            }
        });
    }

    private void addFirstTokenNotEqualsFilter(String token) {
        final String tokenCopy = token;
        this.addMapper(new FilterMapper<ChunkedArgumentExtraction>(){

            @Override
            public boolean doFilter(ChunkedArgumentExtraction extr) {
                return !((String)extr.getPosTags().get(0)).equals(tokenCopy);
            }
        });
    }
}

