/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import edu.washington.cs.knowitall.commonlib.ResourceUtils;
import edu.washington.cs.knowitall.extractor.mapper.FilterMapper;
import edu.washington.cs.knowitall.extractor.mapper.NormalizedRelationDictionaryFilter;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class ReVerbRelationDictionaryFilter
extends FilterMapper<ChunkedExtraction> {
    private static final String relationDictFile = "freq_rel.txt.gz";
    public static final int defaultMinFreq = 20;
    private NormalizedRelationDictionaryFilter filter;

    public ReVerbRelationDictionaryFilter(InputStream in, int minFreq) throws IOException {
        this.init(in, minFreq);
    }

    public ReVerbRelationDictionaryFilter(int minFreq) throws IOException {
        this.init(this.getDefaultRelationStream(), minFreq);
    }

    public ReVerbRelationDictionaryFilter() throws IOException {
        this.init(this.getDefaultRelationStream(), 20);
    }

    private InputStream getDefaultRelationStream() throws IOException {
        InputStream in = ResourceUtils.loadResource((String)relationDictFile, ReVerbRelationDictionaryFilter.class);
        if (in != null) {
            return new GZIPInputStream(in);
        }
        throw new IOException("Could not load file freq_rel.txt.gz from classpath.");
    }

    private void init(InputStream in, int minFreq) throws IOException {
        String line;
        HashSet<String> relations = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        Pattern delim = Pattern.compile("\t");
        int lineNum = 0;
        while ((line = reader.readLine()) != null) {
            ++lineNum;
            String[] fields = delim.split(line);
            if (fields.length != 2) {
                System.err.println("Could not read line " + lineNum + ": '" + line + "'");
                continue;
            }
            int freq = Integer.parseInt(fields[0]);
            if (freq < minFreq) continue;
            relations.add(fields[1]);
        }
        this.filter = new NormalizedRelationDictionaryFilter(relations);
    }

    @Override
    public boolean doFilter(ChunkedExtraction extr) {
        return this.filter.doFilter(extr);
    }
}

