/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.nlp;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.sequence.BIOLayeredSequence;
import edu.washington.cs.knowitall.sequence.SequenceException;
import java.util.List;

public class ChunkedSentence
extends BIOLayeredSequence {
    public static final String TOKEN_LAYER = "tok";
    public static final String POS_LAYER = "pos";
    public static final String NP_LAYER = "np";
    private String tokensAsString = null;
    protected final ImmutableList<Range> offsets;

    public ChunkedSentence(String[] tokens, String[] posTags, String[] npChunkTags) throws SequenceException {
        this(null, (ImmutableList<String>)ImmutableList.copyOf((Object[])tokens), (ImmutableList<String>)ImmutableList.copyOf((Object[])posTags), (ImmutableList<String>)ImmutableList.copyOf((Object[])npChunkTags));
    }

    public ChunkedSentence(Range[] offsets, String[] tokens, String[] posTags, String[] npChunkTags) throws SequenceException {
        this((ImmutableList<Range>)ImmutableList.copyOf((Object[])offsets), (ImmutableList<String>)ImmutableList.copyOf((Object[])tokens), (ImmutableList<String>)ImmutableList.copyOf((Object[])posTags), (ImmutableList<String>)ImmutableList.copyOf((Object[])npChunkTags));
    }

    public ChunkedSentence(ImmutableList<Range> offsets, ImmutableList<String> tokens, ImmutableList<String> posTags, ImmutableList<String> npChunkTags) throws SequenceException {
        super(tokens.size());
        this.offsets = offsets;
        this.addLayer(TOKEN_LAYER, tokens);
        this.addLayer(POS_LAYER, posTags);
        this.addSpanLayer(NP_LAYER, (List<String>)npChunkTags);
    }

    public ChunkedSentence(List<String> tokens, List<String> posTags, List<String> npChunkTags) throws SequenceException {
        this(null, (ImmutableList<String>)ImmutableList.copyOf(tokens), (ImmutableList<String>)ImmutableList.copyOf(posTags), (ImmutableList<String>)ImmutableList.copyOf(npChunkTags));
    }

    public ChunkedSentence(List<Range> offsets, List<String> tokens, List<String> posTags, List<String> npChunkTags) throws SequenceException {
        this((ImmutableList<Range>)(offsets == null ? null : ImmutableList.copyOf(offsets)), (ImmutableList<String>)ImmutableList.copyOf(tokens), (ImmutableList<String>)ImmutableList.copyOf(posTags), (ImmutableList<String>)ImmutableList.copyOf(npChunkTags));
    }

    public ChunkedSentence(ChunkedSentence sent) {
        super(sent.getLength());
        try {
            this.offsets = sent.offsets;
            this.addLayer(TOKEN_LAYER, sent.getTokens());
            this.addLayer(POS_LAYER, sent.getPosTags());
            this.addSpanLayer(NP_LAYER, (List<String>)sent.getChunkTags());
            for (String layerName : sent.getLayerNames()) {
                if (!this.hasLayer(layerName) && sent.isSpanLayer(layerName)) {
                    this.addSpanLayer(layerName, (List<String>)sent.getLayer(layerName));
                    continue;
                }
                if (this.hasLayer(layerName)) continue;
                this.addLayer(layerName, sent.getLayer(layerName));
            }
        }
        catch (SequenceException e) {
            throw new IllegalStateException(e);
        }
    }

    public ImmutableList<Range> getOffsets() {
        return this.offsets;
    }

    public Range getRange() {
        return Range.fromInterval((int)0, (int)(this.getLength() - 1));
    }

    @Override
    public ChunkedSentence getSubSequence(Range range) {
        return this.getSubSequence(range.getStart(), range.getLength());
    }

    @Override
    public ChunkedSentence getSubSequence(int start, int length) {
        try {
            ChunkedSentence result = new ChunkedSentence((List<String>)this.getSubSequence(TOKEN_LAYER, start, length), (List<String>)this.getSubSequence(POS_LAYER, start, length), (List<String>)this.getSubSequence(NP_LAYER, start, length));
            for (String layerName : this.getLayerNames()) {
                if (!result.hasLayer(layerName) && this.isSpanLayer(layerName)) {
                    result.addSpanLayer(layerName, (List<String>)this.getSubSequence(layerName, start, length));
                    continue;
                }
                if (result.hasLayer(layerName)) continue;
                result.addLayer(layerName, this.getSubSequence(layerName, start, length));
            }
            return result;
        }
        catch (SequenceException e) {
            String msg = String.format("Could not create subsequence of length %s starting at %s", length, start);
            throw new IllegalStateException(msg, e);
        }
    }

    public Range getTokenRange(int charStart, int charEnd) {
        if (charStart < 0) {
            throw new IllegalArgumentException("charStart < 0: " + charStart);
        }
        if (charEnd < 0) {
            throw new IllegalArgumentException("charStart < 0: " + charStart);
        }
        int x = 0;
        int i = 0;
        int tokenStart = -1;
        int tokenEnd = -1;
        for (String string : this.getTokens()) {
            if (charStart >= x - 1 && charStart <= x + string.length()) {
                tokenStart = i;
            }
            if (charEnd >= x && charEnd <= x + string.length()) {
                tokenEnd = i + 1;
                break;
            }
            x += string.length() + 1;
            ++i;
        }
        if (tokenStart == -1 || tokenEnd == -1) {
            return null;
        }
        return Range.fromInterval((int)tokenStart, (int)tokenEnd);
    }

    @Override
    public ChunkedSentence clone() {
        try {
            ChunkedSentence clone = new ChunkedSentence((List<String>)this.getTokens(), (List<String>)this.getPosTags(), (List<String>)this.getChunkTags());
            for (String layerName : this.getLayerNames()) {
                if (!clone.hasLayer(layerName) && this.isSpanLayer(layerName)) {
                    clone.addSpanLayer(layerName, (List<String>)this.getLayer(layerName));
                    continue;
                }
                if (clone.hasLayer(layerName)) continue;
                clone.addLayer(layerName, this.getLayer(layerName));
            }
            return clone;
        }
        catch (SequenceException e) {
            String msg = "Could not clone sentence";
            throw new IllegalStateException(msg, e);
        }
    }

    public ImmutableList<String> getTokens() {
        return this.getLayer(TOKEN_LAYER);
    }

    public ImmutableList<String> getPosTags() {
        return this.getLayer(POS_LAYER);
    }

    public ImmutableList<String> getTokens(int start, int length) {
        return this.getSubSequence(TOKEN_LAYER, start, length);
    }

    public ImmutableList<String> getTokens(Range range) {
        return this.getSubSequence(TOKEN_LAYER, range);
    }

    public ImmutableList<String> getPosTags(int start, int length) {
        return this.getSubSequence(POS_LAYER, start, length);
    }

    public ImmutableList<String> getPosTags(Range range) {
        return this.getSubSequence(POS_LAYER, range);
    }

    public ImmutableCollection<Range> getNpChunkRanges() {
        return this.getSpans(NP_LAYER, "NP");
    }

    public ImmutableList<String> getChunkTags() {
        return this.getLayer(NP_LAYER);
    }

    public ImmutableList<String> getChunkTags(int start, int length) {
        return this.getSubSequence(NP_LAYER, start, length);
    }

    public ImmutableList<String> getChunkTags(Range range) {
        return this.getSubSequence(NP_LAYER, range);
    }

    public String getOffsetsAsString() {
        return Joiner.on((String)" ").join(this.offsets);
    }

    public String getTokensAsString() {
        if (this.tokensAsString == null) {
            this.tokensAsString = this.getLayerAsString(TOKEN_LAYER);
        }
        return this.tokensAsString;
    }

    public String getTokensAsString(int start, int length) {
        return this.getLayerAsString(TOKEN_LAYER, start, length);
    }

    public String getTokensAsString(Range range) {
        return this.getTokensAsString(range.getStart(), range.getLength());
    }

    public String getPosTagsAsString(int start, int length) {
        return this.getLayerAsString(POS_LAYER, start, length);
    }

    public String getPosTagsAsString(Range range) {
        return this.getLayerAsString(POS_LAYER, range);
    }

    public String getPosTagsAsString() {
        return this.getLayerAsString(POS_LAYER);
    }

    public String getChunkTagsAsString() {
        return this.getLayerAsString(NP_LAYER);
    }

    public String toString() {
        return this.getTokensAsString();
    }

    public String toOpenNlpFormat() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getLength(); ++i) {
            String tt = this.getToken(i) + "/" + this.getPosTag(i);
            String npChunkTag = this.getChunkTag(i);
            if (i > 0 && !npChunkTag.startsWith("I-") && !this.getChunkTag(i - 1).equals("O")) {
                sb.append("]");
            }
            if (npChunkTag.startsWith("B-")) {
                sb.append(" [" + npChunkTag.substring(2));
            }
            sb.append(" " + tt);
        }
        return sb.toString();
    }

    public String getToken(int i) {
        return this.get(TOKEN_LAYER, i);
    }

    public String getPosTag(int i) {
        return this.get(POS_LAYER, i);
    }

    public String getChunkTag(int i) {
        return this.get(NP_LAYER, i);
    }
}

