/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.nlp;

import com.google.common.base.Function;
import edu.washington.cs.knowitall.logic.ArgFactory;
import edu.washington.cs.knowitall.logic.Expression;
import edu.washington.cs.knowitall.logic.LogicExpression;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.ChunkedSentenceToken;
import edu.washington.cs.knowitall.nlp.ChunkerException;
import edu.washington.cs.knowitall.nlp.OpenNlpSentenceChunker;
import edu.washington.cs.knowitall.regex.Expression;
import edu.washington.cs.knowitall.regex.ExpressionFactory;
import edu.washington.cs.knowitall.regex.Match;
import edu.washington.cs.knowitall.regex.RegularExpression;
import java.io.IOException;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChunkedSentencePattern {
    public static RegularExpression<ChunkedSentenceToken> compile(String regex) {
        return RegularExpression.compile((String)regex, (Function)new ExpressionFactory<ChunkedSentenceToken>(){

            public Expression.BaseExpression<ChunkedSentenceToken> create(final String expression) {
                final Pattern valuePattern = Pattern.compile("([\"'])(.*)\\1");
                return new Expression.BaseExpression<ChunkedSentenceToken>(expression){
                    private final LogicExpression<ChunkedSentenceToken> logic;
                    {
                        super(x0);
                        this.logic = LogicExpression.compile((String)expression, (Function)new ArgFactory<ChunkedSentenceToken>(){

                            public Expression.Arg<ChunkedSentenceToken> create(final String argument) {
                                return new Expression.Arg<ChunkedSentenceToken>(){
                                    private final ChunkedSentenceToken.Expression expression;
                                    {
                                        String[] parts = argument.split("=");
                                        String base = parts[0];
                                        Matcher matcher = valuePattern.matcher(parts[1]);
                                        if (!matcher.matches()) {
                                            throw new IllegalArgumentException("Value not enclosed in quotes (\") or ('): " + argument);
                                        }
                                        String string2 = matcher.group(2);
                                        if (base.equalsIgnoreCase("stringCS")) {
                                            this.expression = new ChunkedSentenceToken.StringExpression(string2, 0);
                                        } else if (base.equalsIgnoreCase("string")) {
                                            this.expression = new ChunkedSentenceToken.StringExpression(string2);
                                        } else if (base.equalsIgnoreCase("pos")) {
                                            this.expression = new ChunkedSentenceToken.PosTagExpression(string2);
                                        } else if (base.equalsIgnoreCase("chunk")) {
                                            this.expression = new ChunkedSentenceToken.ChunkTagExpression(string2);
                                        } else {
                                            throw new IllegalStateException("unknown argument specified: " + base);
                                        }
                                    }

                                    public boolean apply(ChunkedSentenceToken entity) {
                                        return this.expression.apply(entity);
                                    }
                                };
                            }
                        });
                    }

                    public boolean apply(ChunkedSentenceToken entity) {
                        return this.logic.apply((Object)entity);
                    }
                };
            }
        });
    }

    public static void main(String[] args) throws ChunkerException, IOException {
        System.out.println("Compiling the expression... ");
        RegularExpression<ChunkedSentenceToken> expression = ChunkedSentencePattern.compile(args[0]);
        System.out.println(expression);
        OpenNlpSentenceChunker chunker = new OpenNlpSentenceChunker();
        System.out.println("Please enter a sentence to match with the above expression.");
        Scanner scan = new Scanner(System.in);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            ChunkedSentence chunked = chunker.chunkSentence(line);
            Match match = expression.match(ChunkedSentenceToken.tokenize(chunked));
            if (match == null) continue;
            System.out.println(match.groups().get(0));
        }
    }
}

