/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.nlp;

import com.google.common.base.Predicate;
import edu.washington.cs.knowitall.extractor.SentenceExtractor;
import edu.washington.cs.knowitall.io.BufferedReaderIterator;
import edu.washington.cs.knowitall.io.TextBlockIterator;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.ChunkedSentenceIterator;
import edu.washington.cs.knowitall.nlp.OpenNlpSentenceChunker;
import edu.washington.cs.knowitall.nlp.SentenceBlocksIterator;
import edu.washington.cs.knowitall.nlp.SentenceChunker;
import edu.washington.cs.knowitall.util.IterableAdapter;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class ChunkedSentenceReader
implements Iterable<ChunkedSentence> {
    private static OpenNlpSentenceChunker SENT_CHUNKER;
    private SentenceExtractor sentExtractor;
    private SentenceChunker sentChunker;
    private ChunkedSentenceIterator chunkedSentIter;

    public ChunkedSentenceReader(Reader r, SentenceExtractor se) throws IOException {
        if (SENT_CHUNKER == null) {
            SENT_CHUNKER = new OpenNlpSentenceChunker();
        }
        this.init(r, se, SENT_CHUNKER);
    }

    public ChunkedSentenceReader(Reader r, SentenceChunker sc) throws IOException {
        this.init(r, new SentenceExtractor(), sc);
    }

    public ChunkedSentenceReader(Reader r) throws IOException {
        if (SENT_CHUNKER == null) {
            SENT_CHUNKER = new OpenNlpSentenceChunker();
        }
        this.init(r, new SentenceExtractor(), SENT_CHUNKER);
    }

    public ChunkedSentenceReader(Reader r, SentenceExtractor se, SentenceChunker sc) {
        this.init(r, se, sc);
    }

    private void init(Reader reader, SentenceExtractor sentExtractor, SentenceChunker sentChunker) {
        this.sentChunker = sentChunker;
        this.sentExtractor = sentExtractor;
        BufferedReaderIterator bri = new BufferedReaderIterator(reader);
        TextBlockIterator tbi = new TextBlockIterator((Iterator<String>)((Object)bri));
        SentenceBlocksIterator sbi = new SentenceBlocksIterator((Iterator<String>)((Object)tbi), sentExtractor);
        this.chunkedSentIter = new ChunkedSentenceIterator((Iterator<String>)((Object)sbi), sentChunker);
    }

    public void addFilter(Predicate<ChunkedSentence> filter) {
        this.chunkedSentIter.addFilter(filter);
    }

    public SentenceExtractor getSentenceExtractor() {
        return this.sentExtractor;
    }

    public SentenceChunker getSentenceChunker() {
        return this.sentChunker;
    }

    public ChunkedSentenceIterator iterator() {
        return this.chunkedSentIter;
    }

    public Iterable<ChunkedSentence> getSentences() {
        return new IterableAdapter<ChunkedSentence>((Iterator<ChunkedSentence>)((Object)this.chunkedSentIter));
    }
}

