/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.nlp.extraction;

import com.google.common.collect.ImmutableList;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpanExtraction {
    private ChunkedSentence sent;
    private int numFields;
    private ImmutableList<Range> fieldRanges;
    private ImmutableList<ChunkedExtraction> fields;
    private ImmutableList<String> fieldNames;
    private HashMap<String, ChunkedExtraction> namedFields;
    private Map<String, String> props;

    public SpanExtraction(ChunkedSentence sent, List<Range> fieldRanges, List<String> fieldNames) {
        this.initFromRanges(sent, fieldRanges, fieldNames);
    }

    public SpanExtraction(ChunkedSentence sent, List<Range> fieldRanges) {
        int n = fieldRanges.size();
        this.initFromRanges(sent, fieldRanges, SpanExtraction.getDefaultFieldNames(n));
    }

    public SpanExtraction(List<ChunkedExtraction> fields) {
        int n = fields.size();
        this.initFromFields(fields, SpanExtraction.getDefaultFieldNames(n));
    }

    public SpanExtraction(ChunkedExtraction[] fields) {
        ArrayList<ChunkedExtraction> fieldsList = new ArrayList<ChunkedExtraction>(fields.length);
        for (ChunkedExtraction field : fields) {
            fieldsList.add(field);
        }
        this.initFromFields(fieldsList, SpanExtraction.getDefaultFieldNames(fieldsList.size()));
    }

    public SpanExtraction(List<ChunkedExtraction> fields, List<String> fieldNames) {
        this.initFromFields(fields, fieldNames);
    }

    public SpanExtraction(ChunkedExtraction[] fields, String[] fieldNames) {
        ArrayList<ChunkedExtraction> fieldsList = new ArrayList<ChunkedExtraction>(fields.length);
        for (ChunkedExtraction field : fields) {
            fieldsList.add(field);
        }
        ArrayList<String> fieldNamesList = new ArrayList<String>(fieldNames.length);
        for (String name : fieldNames) {
            fieldNamesList.add(name);
        }
        this.initFromFields(fieldsList, fieldNamesList);
    }

    public int getNumFields() {
        return this.fieldRanges.size();
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public boolean hasField(String name) {
        return this.namedFields.containsKey(name);
    }

    public ChunkedSentence getSentence() {
        return this.sent;
    }

    public List<Range> getFieldRanges() {
        return this.fieldRanges;
    }

    public List<ChunkedExtraction> getFields() {
        return this.fields;
    }

    public Range getFieldRange(int i) {
        return this.getFieldRanges().get(i);
    }

    public Range getFieldRange(String name) {
        return this.namedFields.get(name).getRange();
    }

    public ChunkedExtraction getField(String name) {
        return this.namedFields.get(name);
    }

    public ChunkedExtraction getField(int i) {
        return this.getFields().get(i);
    }

    public String getFieldName(int i) {
        return this.getFieldNames().get(i);
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    public void setProperty(String name, String value) {
        this.props.put(name, value);
    }

    public void setProperties(Map<String, String> props) {
        this.props = props;
    }

    public boolean hasProperty(String name) {
        return this.props.containsKey(name);
    }

    public String getProperty(String name) {
        if (this.hasProperty(name)) {
            return this.props.get(name);
        }
        throw new IllegalArgumentException("Invalid property name: " + name);
    }

    public Set<String> getPropertyNames() {
        return this.props.keySet();
    }

    public List<String> toBIOLayer() {
        int n = this.getSentence().getLength();
        ArrayList<String> result = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            result.add("O");
        }
        for (String fieldName : this.getFieldNames()) {
            Range r = this.getFieldRange(fieldName);
            int start = r.getStart();
            int end = r.getEnd();
            result.set(start, "B-" + fieldName);
            for (int j = start + 1; j < end; ++j) {
                result.set(j, "I-" + fieldName);
            }
        }
        return result;
    }

    private void initFromRanges(ChunkedSentence sent, List<Range> fieldRanges, List<String> fieldNames) {
        if (fieldRanges.size() < 1) {
            throw new IllegalArgumentException("must have at least 1 field");
        }
        if (fieldNames.size() != fieldRanges.size()) {
            throw new IllegalArgumentException("length of ranges must equal length of fieldNames");
        }
        this.sent = sent;
        this.numFields = fieldRanges.size();
        this.fieldRanges = ImmutableList.copyOf(fieldRanges);
        ArrayList<ChunkedExtraction> tFields = new ArrayList<ChunkedExtraction>(this.numFields);
        this.namedFields = new HashMap(this.numFields);
        for (int i = 0; i < this.numFields; ++i) {
            Range range = fieldRanges.get(i);
            ChunkedExtraction field = new ChunkedExtraction(sent, range);
            String fieldName = fieldNames.get(i);
            tFields.add(field);
            this.namedFields.put(fieldName, field);
        }
        this.fields = ImmutableList.copyOf(tFields);
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.props = new HashMap<String, String>();
    }

    private void initFromFields(List<ChunkedExtraction> fields, List<String> fieldNames) {
        int i;
        ArrayList<Range> tFieldRanges = new ArrayList<Range>(fields.size());
        for (ChunkedExtraction field : fields) {
            tFieldRanges.add(field.getRange());
        }
        if (fields.size() < 1) {
            throw new IllegalArgumentException("must have at least 1 field");
        }
        for (i = 0; i < fields.size(); ++i) {
            ChunkedSentence sent2;
            ChunkedSentence sent1 = fields.get(i).getSentence();
            if (sent1.equals(sent2 = fields.get((i + 1) % fields.size()).getSentence())) continue;
            throw new IllegalArgumentException("fields must come from the same sentence");
        }
        this.sent = fields.get(0).getSentence();
        this.numFields = fields.size();
        this.fieldRanges = ImmutableList.copyOf(tFieldRanges);
        this.fields = ImmutableList.copyOf(fields);
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.namedFields = new HashMap(this.numFields);
        for (i = 0; i < this.numFields; ++i) {
            this.namedFields.put(fieldNames.get(i), fields.get(i));
        }
        this.props = new HashMap<String, String>();
    }

    private static List<String> getDefaultFieldNames(int n) {
        ArrayList<String> result = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            result.add("field" + i);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fieldNames == null ? 0 : this.fieldNames.hashCode());
        result = 31 * result + (this.fieldRanges == null ? 0 : this.fieldRanges.hashCode());
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        result = 31 * result + (this.namedFields == null ? 0 : this.namedFields.hashCode());
        result = 31 * result + this.numFields;
        result = 31 * result + (this.props == null ? 0 : this.props.hashCode());
        result = 31 * result + (this.sent == null ? 0 : this.sent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpanExtraction other = (SpanExtraction)obj;
        if (this.fieldNames == null ? other.fieldNames != null : !this.fieldNames.equals(other.fieldNames)) {
            return false;
        }
        if (this.fieldRanges == null ? other.fieldRanges != null : !this.fieldRanges.equals(other.fieldRanges)) {
            return false;
        }
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        if (this.namedFields == null ? other.namedFields != null : !this.namedFields.equals(other.namedFields)) {
            return false;
        }
        if (this.numFields != other.numFields) {
            return false;
        }
        if (this.props == null ? other.props != null : !this.props.equals(other.props)) {
            return false;
        }
        return !(this.sent == null ? other.sent != null : !this.sent.equals(other.sent));
    }
}

