/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.normalization;

import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import edu.washington.cs.knowitall.normalization.FieldNormalizer;
import edu.washington.cs.knowitall.normalization.NormalizedField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class ArgumentNormalizer
implements FieldNormalizer {
    private HashSet<String> ignorePosTags = new HashSet();

    public ArgumentNormalizer() {
        this.ignorePosTags.add("``");
        this.ignorePosTags.add("''");
        this.ignorePosTags.add("-LRB-");
        this.ignorePosTags.add("-RRB");
    }

    @Override
    public NormalizedField normalizeField(ChunkedExtraction field) {
        ArrayList<String> tokens = new ArrayList<String>((Collection<String>)field.getTokens());
        ArrayList<String> tags = new ArrayList<String>((Collection<String>)field.getPosTags());
        int i = 0;
        while (i < tokens.size()) {
            String token = tokens.get(i);
            String tag = tags.get(i);
            if (this.ignorePosTags.contains(tag)) {
                tokens.remove(i);
                tags.remove(i);
                continue;
            }
            token = tag.equals("CD") ? "#" : token.toLowerCase();
            tokens.set(i, token);
            ++i;
        }
        return new NormalizedField(field, tokens, tags);
    }
}

