/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.sequence;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.TreeMultimap;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.sequence.SequenceException;
import edu.washington.cs.knowitall.sequence.SimpleLayeredSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class BIOLayeredSequence
extends SimpleLayeredSequence {
    private HashMap<String, List<Range>> spans = new HashMap();
    private HashMap<String, ImmutableMultimap<String, Range>> spanTypes = new HashMap();

    public BIOLayeredSequence(int length) {
        super(length);
    }

    public BIOLayeredSequence clone() {
        BIOLayeredSequence clone = new BIOLayeredSequence(this.getLength());
        for (String layerName : this.getLayerNames()) {
            if (this.isSpanLayer(layerName)) {
                clone.addSpanLayer(layerName, (List<String>)this.getLayer(layerName));
                continue;
            }
            clone.addLayer(layerName, this.getLayer(layerName));
        }
        return clone;
    }

    public List<Range> getSpans(String layerName) {
        if (this.hasLayer(layerName)) {
            if (this.spans.containsKey(layerName)) {
                return this.spans.get(layerName);
            }
            return new ArrayList<Range>();
        }
        throw new IllegalArgumentException("Invalid layer name: " + layerName);
    }

    public ImmutableCollection<Range> getSpans(String layerName, String type) {
        if (this.hasLayer(layerName)) {
            if (this.spans.containsKey(layerName) && this.spanTypes.get(layerName).containsKey((Object)type)) {
                return this.spanTypes.get(layerName).get((Object)type);
            }
            return ImmutableSet.of();
        }
        throw new IllegalArgumentException("Invalid layer name: " + layerName);
    }

    public void addSpanLayer(String layerName, List<String> input) throws SequenceException {
        ImmutableMultimap typeToSpans = ImmutableMultimap.copyOf(this.getRanges(input));
        ArrayList allRanges = new ArrayList();
        Collections.sort(allRanges);
        super.addLayer(layerName, input);
        this.spans.put(layerName, (List<Range>)ImmutableList.copyOf((Collection)typeToSpans.values()));
        this.spanTypes.put(layerName, (ImmutableMultimap<String, Range>)typeToSpans);
    }

    public void addSpanLayerRanges(String layerName, String tag, List<Range> ranges) throws SequenceException {
        ArrayList<Range> rangesCopy = new ArrayList<Range>(ranges.size());
        rangesCopy.addAll(ranges);
        Collections.sort(ranges);
        if (!Range.isDisjoint(ranges)) {
            throw new SequenceException("ranges cannot overlap");
        }
        ArrayList<String> sequence = new ArrayList<String>(this.getLength());
        for (int i = 0; i < this.getLength(); ++i) {
            sequence.add("O");
        }
        for (Range range : ranges) {
            int first = range.getStart();
            int end = range.getEnd();
            if (end > this.getLength()) {
                throw new IndexOutOfBoundsException("Range out of bounds: " + range);
            }
            sequence.set(first, "B-" + tag);
            for (int i = first + 1; i < end; ++i) {
                sequence.set(i, "I-" + tag);
            }
        }
        this.addSpanLayer(layerName, sequence);
    }

    @Override
    public ImmutableList<String> getSubSequence(String layerName, int start, int length) {
        ImmutableList<String> subLayer = super.getSubSequence(layerName, start, length);
        if (this.spans.containsKey(layerName)) {
            ArrayList<String> spanSub = new ArrayList<String>(length);
            spanSub.addAll((Collection<String>)subLayer);
            if (spanSub.size() > 0 && ((String)spanSub.get(0)).startsWith("I-")) {
                try {
                    String type = this.getType((String)spanSub.get(0));
                    spanSub.set(0, "B-" + type);
                }
                catch (SequenceException e) {
                    // empty catch block
                }
            }
            return ImmutableList.copyOf(spanSub);
        }
        return subLayer;
    }

    public ImmutableList<String> getSubSequence(String layerName, Range r) {
        if (r == null) {
            throw new IllegalArgumentException("range cannot be null.");
        }
        return this.getSubSequence(layerName, r.getStart(), r.getLength());
    }

    @Override
    public BIOLayeredSequence getSubSequence(int start, int length) {
        BIOLayeredSequence sub = new BIOLayeredSequence(length);
        for (String layerName : this.getLayerNames()) {
            ImmutableList<String> subLayer = this.getSubSequence(layerName, start, length);
            try {
                if (this.isSpanLayer(layerName)) {
                    sub.addSpanLayer(layerName, (List<String>)subLayer);
                    continue;
                }
                sub.addLayer(layerName, (List<String>)subLayer);
            }
            catch (SequenceException e) {
                String msg = String.format("Could not create subsequence of length %s starting at %s for layer %s", start, length, layerName);
                throw new IllegalStateException(msg, e);
            }
        }
        return sub;
    }

    @Override
    public BIOLayeredSequence getSubSequence(Range r) {
        return this.getSubSequence(r.getStart(), r.getLength());
    }

    protected boolean isSpanLayer(String layerName) {
        return this.spans.containsKey(layerName);
    }

    private TreeMultimap<String, Range> getRanges(List<String> tags) throws SequenceException {
        String inType = null;
        int startIndex = -1;
        int length = 0;
        TreeMultimap results = TreeMultimap.create();
        for (int i = 0; i < tags.size(); ++i) {
            String tag = tags.get(i);
            if (inType != null && !tag.equals("I-" + inType)) {
                Range r = new Range(startIndex, length);
                results.put((Object)inType, (Object)r);
                inType = null;
                startIndex = -1;
                length = 0;
            }
            if (tag.startsWith("B-")) {
                inType = this.getType(tag);
                startIndex = i;
                length = 1;
                continue;
            }
            if (!tag.startsWith("I-") || inType == null || !tag.equals("I-" + inType)) continue;
            ++length;
        }
        if (inType != null) {
            Range r = new Range(startIndex, length);
            results.put(inType, (Object)r);
        }
        return results;
    }

    private String getType(String tag) throws SequenceException {
        String[] splitTag = tag.split("-");
        if (splitTag.length == 2) {
            return splitTag[1];
        }
        throw new SequenceException("Invalid tag: " + tag);
    }
}

