/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.sequence;

import com.google.common.base.Joiner;
import edu.washington.cs.knowitall.sequence.Encoder;
import edu.washington.cs.knowitall.sequence.LayeredPatternTokenizer;
import edu.washington.cs.knowitall.sequence.LayeredSequence;
import edu.washington.cs.knowitall.sequence.LayeredTokenMatcher;
import edu.washington.cs.knowitall.sequence.SequenceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LayeredTokenPattern {
    private String patternString;
    private LayeredPatternTokenizer tokenizer;
    private int patternLength;
    private String[] patternTokens;
    private String[] patternSymbols;
    private String[] patternLayerNames;
    private List<String> layerNames;
    private Map<String, Set<String>> layerAlphabets;
    private Encoder encoder;
    private String encodedPatternString;
    private Pattern encodedPattern;

    public LayeredTokenPattern(String patternString) throws SequenceException {
        this.patternString = patternString;
        this.tokenizePattern();
        this.validatePattern();
        this.buildAlphabets();
        this.buildEncoder();
        this.encodePattern();
    }

    public String toString() {
        return this.patternString;
    }

    private void validatePattern() throws SequenceException {
        for (int i = 0; i < this.patternLength - 1; ++i) {
            String t1 = this.patternTokens[i];
            String t2 = this.patternTokens[i + 1];
            if (!t1.equals("[") || !t2.equals("^")) continue;
            String msg = String.format("Could not create pattern '%s': negative classes are not supported", this.patternString);
            throw new SequenceException(msg);
        }
    }

    private void tokenizePattern() throws SequenceException {
        this.tokenizer = new LayeredPatternTokenizer();
        this.patternTokens = this.tokenizer.tokenize(this.patternString);
        this.patternLength = this.patternTokens.length;
        this.patternSymbols = new String[this.patternLength];
        this.patternLayerNames = new String[this.patternLength];
        for (int i = 0; i < this.patternLength; ++i) {
            String token = this.patternTokens[i];
            if (this.tokenizer.isSymbolLayerName(token)) {
                String[] splitToken = this.tokenizer.getSymbolLayerName(token);
                this.patternSymbols[i] = splitToken[0];
                this.patternLayerNames[i] = splitToken[1];
                continue;
            }
            this.patternSymbols[i] = null;
            this.patternLayerNames[i] = null;
        }
    }

    private void buildAlphabets() {
        this.layerNames = new ArrayList<String>();
        this.layerAlphabets = new HashMap<String, Set<String>>();
        for (int i = 0; i < this.patternLength; ++i) {
            String layerName = this.patternLayerNames[i];
            if (layerName != null && !this.layerAlphabets.containsKey(layerName)) {
                this.layerNames.add(layerName);
                this.layerAlphabets.put(layerName, new HashSet());
            }
            String symbol = this.patternSymbols[i];
            if (layerName == null || symbol == null) continue;
            this.layerAlphabets.get(layerName).add(symbol);
        }
    }

    private void buildEncoder() throws SequenceException {
        ArrayList<Set<String>> sets = new ArrayList<Set<String>>();
        for (String layerName : this.layerNames) {
            sets.add(this.layerAlphabets.get(layerName));
        }
        this.encoder = new Encoder(sets);
    }

    private void encodePattern() throws SequenceException {
        Object[] encodedTokens = new String[this.patternLength];
        for (int i = 0; i < this.patternLength; ++i) {
            String symbol = this.patternSymbols[i];
            String layerName = this.patternLayerNames[i];
            if (symbol == null || layerName == null) {
                encodedTokens[i] = this.patternTokens[i];
                continue;
            }
            int layerIndex = this.layerNames.indexOf(layerName);
            char[] classEncoding = this.encoder.encodeClass(layerIndex, symbol);
            String classEncodingString = new String(classEncoding);
            encodedTokens[i] = "[" + Pattern.quote(classEncodingString) + "]";
        }
        this.encodedPatternString = Joiner.on((String)"").join(encodedTokens);
        this.encodedPattern = Pattern.compile(this.encodedPatternString);
    }

    public LayeredTokenMatcher matcher(LayeredSequence seq) throws SequenceException {
        String encoded = this.encodeSequence(seq);
        Matcher m = this.encodedPattern.matcher(encoded);
        return new LayeredTokenMatcher(m);
    }

    private String encodeSequence(LayeredSequence seq) throws SequenceException {
        int n = seq.getLength();
        char[] encoded = new char[n];
        for (int i = 0; i < n; ++i) {
            String[] tuple = this.getTupleAt(seq, i);
            encoded[i] = this.encoder.encode(tuple);
        }
        return new String(encoded);
    }

    private String[] getTupleAt(LayeredSequence seq, int i) throws SequenceException {
        String[] tuple = new String[this.encoder.size()];
        for (int j = 0; j < this.layerNames.size(); ++j) {
            String layerName = this.layerNames.get(j);
            if (!seq.hasLayer(layerName)) {
                String msg = String.format("seq does not have layer with name '%s'", layerName);
                throw new SequenceException(msg);
            }
            tuple[j] = seq.get(this.layerNames.get(j), i);
        }
        return tuple;
    }

    public Pattern getEncodedPattern() {
        return this.encodedPattern;
    }
}

