/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.sequence;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.sequence.LayeredSequence;
import edu.washington.cs.knowitall.sequence.SequenceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SimpleLayeredSequence
implements LayeredSequence {
    private HashMap<String, ImmutableList<String>> layers;
    private HashSet<String> layerNames;
    private int numLayers;
    private int length;

    public SimpleLayeredSequence(int length) {
        this.init();
        this.length = length;
        this.numLayers = 0;
    }

    private void init() {
        this.layers = new HashMap();
        this.layerNames = new HashSet();
    }

    public ImmutableList<String> getLayer(String layerName) {
        if (this.hasLayer(layerName)) {
            return this.layers.get(layerName);
        }
        throw new IllegalArgumentException("Invalid layer name: " + layerName);
    }

    @Override
    public int getNumLayers() {
        return this.numLayers;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void addLayer(String layerName, ImmutableList<String> layer) throws SequenceException {
        if (this.hasLayer(layerName)) {
            String msg = String.format("Cannot add layer '%s': layer already exists", layerName);
            throw new SequenceException(msg);
        }
        if (layer.size() != this.length) {
            String msg = String.format("Cannot add layer '%s': layer parameter has invalid length (expected %s, but got %s)", layerName, this.length, layer.size());
            throw new SequenceException(msg);
        }
        this.layerNames.add(layerName);
        this.layers.put(layerName, layer);
        ++this.numLayers;
    }

    public void addLayer(String layerName, List<String> layer) {
        this.addLayer(layerName, (ImmutableList<String>)ImmutableList.copyOf(layer));
    }

    public void addLayer(String layerName, String[] layer) throws SequenceException {
        ArrayList<String> layerList = new ArrayList<String>(layer.length);
        for (int i = 0; i < layer.length; ++i) {
            layerList.add(layer[i]);
        }
        this.addLayer(layerName, layerList);
    }

    @Override
    public boolean hasLayer(String layerName) {
        return this.layerNames.contains(layerName);
    }

    @Override
    public String get(String layerName, int index) {
        ImmutableList<String> layer = this.getLayer(layerName);
        return (String)layer.get(index);
    }

    public ImmutableList<String> getSubSequence(String layerName, int start, int length) {
        return this.getLayer(layerName).subList(start, start + length);
    }

    public List<String> getSubSequence(String layerName, Range r) {
        return this.getSubSequence(layerName, r.getStart(), r.getLength());
    }

    public SimpleLayeredSequence getSubSequence(int start, int length) {
        SimpleLayeredSequence sub = new SimpleLayeredSequence(length);
        for (String layerName : this.getLayerNames()) {
            try {
                sub.addLayer(layerName, this.getSubSequence(layerName, start, length));
            }
            catch (SequenceException e) {
                String msg = String.format("Could not create subsequence of length %s starting at %s for layer %s", start, length, layerName);
                throw new IllegalStateException(msg, e);
            }
        }
        return sub;
    }

    public SimpleLayeredSequence getSubSequence(Range r) {
        return this.getSubSequence(r.getStart(), r.getLength());
    }

    @Override
    public Collection<String> getLayerNames() {
        return this.layerNames;
    }

    public String getLayerAsString(String layerName) {
        return this.getLayerAsString(layerName, 0, this.getLength());
    }

    public String getLayerAsString(String layerName, Range r) {
        return this.getLayerAsString(layerName, r.getStart(), r.getLength());
    }

    public String getLayerAsString(String layerName, int start, int length) {
        ImmutableList<String> sub = this.getSubSequence(layerName, start, length);
        return Joiner.on((String)" ").join(sub.iterator());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.layerNames == null ? 0 : this.layerNames.hashCode());
        result = 31 * result + (this.layers == null ? 0 : this.layers.hashCode());
        result = 31 * result + this.length;
        result = 31 * result + this.numLayers;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleLayeredSequence)) {
            return false;
        }
        SimpleLayeredSequence other = (SimpleLayeredSequence)obj;
        if (this.layerNames == null ? other.layerNames != null : !this.layerNames.equals(other.layerNames)) {
            return false;
        }
        if (this.layers == null ? other.layers != null : !this.layers.equals(other.layers)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return this.numLayers == other.numLayers;
    }
}

