/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.util;

import com.google.common.base.Joiner;
import edu.washington.cs.knowitall.argumentidentifier.ConfidenceMetric;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.extractor.ExtractorException;
import edu.washington.cs.knowitall.extractor.R2A2;
import edu.washington.cs.knowitall.extractor.ReVerbExtractor;
import edu.washington.cs.knowitall.extractor.ReVerbRelationExtractor;
import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunction;
import edu.washington.cs.knowitall.extractor.conf.ConfidenceFunctionException;
import edu.washington.cs.knowitall.extractor.conf.ReVerbOpenNlpConfFunction;
import edu.washington.cs.knowitall.extractor.mapper.PronounArgumentFilter;
import edu.washington.cs.knowitall.io.BufferedReaderIterator;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.ChunkedSentenceIterator;
import edu.washington.cs.knowitall.nlp.ChunkedSentenceReader;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import edu.washington.cs.knowitall.normalization.BinaryExtractionNormalizer;
import edu.washington.cs.knowitall.normalization.NormalizedBinaryExtraction;
import edu.washington.cs.knowitall.util.DefaultObjects;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CommandLineReVerb {
    private static final String NAME = "CommandLineReVerb";
    private ReVerbRelationExtractor extractor;
    private ConfidenceFunction confFunc;
    private BufferedReaderIterator stdinLineIterator;
    private BinaryExtractionNormalizer normalizer;
    private long startAtTime;
    private boolean dataStdin = false;
    private boolean fileListStdin = false;
    private boolean stripHtml = false;
    private boolean quiet = false;
    private boolean timing = false;
    private boolean filterPronouns = false;
    private boolean mergeOverlapRels = false;
    private boolean useSynLexConstraints = false;
    private boolean allowUnary = false;
    private boolean useArgLearner = false;
    private int minFreq = 20;
    private int messageEvery = 1000;
    private int numSents = 0;
    private int numExtrs = 0;
    private int numFiles = 0;
    private String currentFile;
    private Queue<String> fileArgs;
    long chunkTime = 0L;
    long extractTime = 0L;
    long confTime = 0L;
    private static String[] colNames = new String[]{"filename", "sentence number", "arg1", "rel", "arg2", "arg1 start", "arg1 end", "rel start", "rel end", "arg2 start", "arg2 end", "conf", "sentence words", "sentence pos tags", "sentence chunk tags", "arg1 normalized", "rel normalized", "arg2 normalized"};

    public static void main(String[] args) throws ExtractorException {
        Options options = new Options();
        options.addOption("h", "help", false, "Print help and exit");
        options.addOption("f", "files", false, "Read file list from standard input");
        options.addOption("s", "strip-html", false, "Strip HTML before extracting");
        options.addOption("p", "filter-pronouns", false, "Filter out arguments that contain a pronoun");
        options.addOption("q", "quiet", false, "Quiet mode (don't print messages to standard error)");
        options.addOption("t", "timing", false, "Provide detailed timing information");
        options.addOption("m", "minFreq", true, "Each relation must have at a minimum this many number of distinct arguments in a large corpus.");
        options.addOption("a", "argLearner", false, "Use ArgLearner to identify extraction arguments (experimental, slower but more accurate). If you use this setting, the minFreq, noConstraints, keepOverlap, and allowUnary values will be ignored.");
        options.addOption("K", "keepOverlap", false, "Do not merge overlapping relations (Default is to merge.)");
        options.addOption("U", "allowUnary", false, "Allow relations with a single argument to be output. (Default setting is to disallow unary relations.)");
        options.addOption("N", "noConstraints", false, "Do not enforce the syntactic and lexical constraints that are part of ReVerb.");
        PosixParser parser = new PosixParser();
        try {
            CommandLine params = parser.parse(options, args);
            if (params.hasOption("h")) {
                CommandLineReVerb.usage(options);
                return;
            }
            CommandLineReVerb clReVerb = new CommandLineReVerb(params);
            clReVerb.runExtractor();
        }
        catch (ParseException e) {
            System.err.println("Could not parse command line arguments: " + e.getMessage());
            CommandLineReVerb.usage(options);
            return;
        }
        catch (IOException e) {
            System.err.println("Encountered IOException: " + e.getMessage());
            return;
        }
    }

    public static void usage(Options options) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp(String.format("%s [OPTIONS] [FILES]", NAME), options);
        System.out.println();
        CommandLineReVerb.printOutputFormatHelp();
        System.out.println();
    }

    private static void printOutputFormatHelp() {
        System.out.println("Output Columns:");
        for (int i = 0; i < colNames.length; ++i) {
            int j = i + 1;
            System.out.println("    " + j + ". " + colNames[i]);
        }
    }

    public CommandLineReVerb(CommandLine params) throws ExtractorException {
        this.quiet = params.hasOption("quiet");
        this.timing = params.hasOption("timing");
        if (params.hasOption("files")) {
            this.dataStdin = false;
            this.fileListStdin = true;
            this.stdinLineIterator = new BufferedReaderIterator(new BufferedReader(new InputStreamReader(System.in)));
        } else if (params.getArgs().length > 0) {
            this.dataStdin = false;
            this.fileListStdin = false;
            this.fileArgs = new LinkedList<String>();
            for (String arg : params.getArgs()) {
                this.fileArgs.add(arg);
            }
        } else {
            this.dataStdin = true;
            this.fileListStdin = false;
        }
        this.stripHtml = params.hasOption("strip-html");
        this.filterPronouns = params.hasOption("filter-pronouns");
        this.minFreq = Integer.parseInt(params.getOptionValue("minFreq", "20"));
        this.mergeOverlapRels = !params.hasOption("keepOverlap");
        this.useSynLexConstraints = !params.hasOption("noConstraints");
        this.allowUnary = params.hasOption("allowUnary");
        this.useArgLearner = params.hasOption("argLearner");
        this.normalizer = new BinaryExtractionNormalizer();
        try {
            if (this.useArgLearner) {
                this.messageInc("Initializing ReVerb+ArgLearner extractor...");
                this.extractor = new R2A2();
                this.message("Done.");
                this.messageInc("Initializing confidence function...");
                this.confFunc = new ConfidenceMetric();
                this.message("Done.");
            } else {
                this.messageInc("Initializing ReVerb extractor...");
                this.extractor = new ReVerbExtractor(this.minFreq, this.useSynLexConstraints, this.mergeOverlapRels, this.allowUnary);
                this.message("Done.");
                this.messageInc("Initializing confidence function...");
                this.confFunc = new ReVerbOpenNlpConfFunction();
                this.message("Done.");
            }
            if (this.filterPronouns) {
                this.extractor.getArgument1Extractor().addMapper(new PronounArgumentFilter());
                this.extractor.getArgument2Extractor().addMapper(new PronounArgumentFilter());
            }
            this.messageInc("Initializing NLP tools...");
            DefaultObjects.initializeNlpTools();
            this.message("Done.");
        }
        catch (ConfidenceFunctionException e) {
            throw new ExtractorException(e);
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
    }

    public void runExtractor() throws IOException, ExtractorException {
        this.message("Starting extraction.");
        this.startAtTime = System.currentTimeMillis();
        if (this.dataStdin) {
            this.extractFromStdin();
        } else {
            while (this.haveNextFile()) {
                try {
                    this.extractFromNextFile();
                }
                catch (ExtractorException e) {
                    this.message("Error during extraction: " + e.getMessage());
                }
                catch (IOException e) {
                    this.message("Error reading file: " + e.getMessage());
                }
                ++this.numFiles;
            }
        }
        this.message("Done with extraction.");
        this.summary();
    }

    private void summary() {
        long currentTime = System.currentTimeMillis();
        long runTimeSecs = (currentTime - this.startAtTime) / 1000L;
        this.messageInc("Summary: ");
        this.messageInc(this.numExtrs + " extractions, ");
        this.messageInc(this.numSents + " sentences, ");
        this.messageInc(this.numFiles + " files, ");
        this.message(runTimeSecs + " seconds");
        if (this.timing) {
            DecimalFormat fmt = new DecimalFormat("#.##");
            this.messageInc("Timing: ");
            this.messageInc("chunking: " + fmt.format((double)this.chunkTime / 1000.0 / 1000.0 / 1000.0) + " s, ");
            this.messageInc("extraction: " + fmt.format((double)this.extractTime / 1000.0 / 1000.0 / 1000.0) + " s, ");
            this.messageInc("confidence: " + fmt.format((double)this.confTime / 1000.0 / 1000.0 / 1000.0) + " s");
        }
    }

    private void message(String msg) {
        if (!this.quiet) {
            System.err.println(msg);
        }
    }

    private void messageInc(String msg) {
        if (!this.quiet) {
            System.err.print(msg);
        }
    }

    private boolean haveNextFile() throws IOException {
        if (this.fileListStdin) {
            return this.stdinLineIterator.hasNext();
        }
        return this.fileArgs.size() > 0;
    }

    private File getNextFile() throws IOException {
        if (this.fileListStdin) {
            return new File((String)this.stdinLineIterator.next());
        }
        return new File(this.fileArgs.remove());
    }

    private void extractFromNextFile() throws IOException, ExtractorException {
        File f = this.getNextFile();
        this.currentFile = f.getAbsolutePath();
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        ChunkedSentenceReader reader = this.getSentenceReader(in);
        this.message("Extracting from " + f);
        this.extractFromSentReader(reader);
    }

    private void extractFromStdin() throws IOException, ExtractorException {
        this.currentFile = "stdin";
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        ChunkedSentenceReader reader = this.getSentenceReader(in);
        this.extractFromSentReader(reader);
    }

    private ChunkedSentenceReader getSentenceReader(BufferedReader in) throws IOException {
        if (this.stripHtml) {
            return DefaultObjects.getDefaultSentenceReaderHtml(in);
        }
        return DefaultObjects.getDefaultSentenceReader(in);
    }

    private double getConf(ChunkedBinaryExtraction extr) {
        try {
            return this.confFunc.getConf(extr);
        }
        catch (ConfidenceFunctionException e) {
            System.err.println("Could not compute confidence for " + extr + ": " + e.getMessage());
            return 0.0;
        }
    }

    private void extractFromSentReader(ChunkedSentenceReader reader) throws ExtractorException {
        ChunkedSentenceIterator sentenceIt = reader.iterator();
        while (sentenceIt.hasNext()) {
            ChunkedSentence sent = (ChunkedSentence)sentenceIt.next();
            this.chunkTime += sentenceIt.getLastComputeTime();
            ++this.numSents;
            long start = System.nanoTime();
            Iterable extractions = this.extractor.extract(sent);
            this.extractTime += System.nanoTime() - start;
            for (ChunkedBinaryExtraction extr : extractions) {
                ++this.numExtrs;
                start = System.nanoTime();
                double conf = this.getConf(extr);
                this.confTime += System.nanoTime() - start;
                NormalizedBinaryExtraction extrNorm = this.normalizer.normalize(extr);
                this.printExtr(extrNorm, conf);
            }
            if (this.numSents % this.messageEvery != 0) continue;
            this.summary();
        }
    }

    private void printExtr(NormalizedBinaryExtraction extr, double conf) {
        String arg1 = extr.getArgument1().toString();
        String rel = extr.getRelation().toString();
        String arg2 = extr.getArgument2().toString();
        ChunkedSentence sent = extr.getSentence();
        String toks = sent.getTokensAsString();
        String pos = sent.getPosTagsAsString();
        String chunks = sent.getChunkTagsAsString();
        String arg1Norm = extr.getArgument1Norm().toString();
        String relNorm = extr.getRelationNorm().toString();
        String arg2Norm = extr.getArgument2Norm().toString();
        Range arg1Range = extr.getArgument1().getRange();
        Range relRange = extr.getRelation().getRange();
        Range arg2Range = extr.getArgument2().getRange();
        String a1s = String.valueOf(arg1Range.getStart());
        String a1e = String.valueOf(arg1Range.getEnd());
        String rs = String.valueOf(relRange.getStart());
        String re = String.valueOf(relRange.getEnd());
        String a2s = String.valueOf(arg2Range.getStart());
        String a2e = String.valueOf(arg2Range.getEnd());
        String row = Joiner.on((String)"\t").join((Object[])new String[]{this.currentFile, String.valueOf(this.numSents), arg1, rel, arg2, a1s, a1e, rs, re, a2s, a2e, String.valueOf(conf), toks, pos, chunks, arg1Norm, relNorm, arg2Norm});
        System.out.println(row);
    }
}

