/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.argumentidentifier;

import com.google.common.collect.ImmutableList;
import edu.washington.cs.knowitall.argumentidentifier.PatternExtractor;
import edu.washington.cs.knowitall.extractor.conf.classifier.DoubleFeatures;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;

public class Arg1LocationFeatureGenerator {
    PatternExtractor patternExtractor = new PatternExtractor();

    public String getHeader() {
        String header = "@RELATION np_head\n@ATTRIBUTE simple_subj   {true,false}\n@ATTRIBUTE quotes_subj   {true,false}\n@ATTRIBUTE relative_subj   {true,false}\n@ATTRIBUTE verb_conj   {true,false}\n@ATTRIBUTE app   {true,false}\n@ATTRIBUTE which_who   {true,false}\n@ATTRIBUTE cap   {true,false}\n@ATTRIBUTE punt_count  NUMERIC\n@ATTRIBUTE intervening_np_count  NUMERIC\n@ATTRIBUTE np_count_before  NUMERIC\n@ATTRIBUTE word_before_pred_conj   {true,false}\n@ATTRIBUTE intervening_and  {true,false}\n@ATTRIBUTE word_after_vp  {true,false}\n@ATTRIBUTE word_before_vp  {true,false}\n@ATTRIBUTE class        {closest_np,not_closest_np}\n@DATA\n";
        return header;
    }

    public double toDouble(boolean bool) {
        if (bool) {
            return 1.0;
        }
        return 0.0;
    }

    public double toDouble(int num) {
        return (double)num + 0.0;
    }

    public double toDouble(double num) {
        return num;
    }

    public DoubleFeatures extractFeatures(ChunkedExtraction extr, ChunkedArgumentExtraction arg1, int current, boolean train) {
        ImmutableList<String> words = extr.getSentence().getTokens();
        ImmutableList<String> chunks = extr.getSentence().getChunkTags();
        int pred_start = extr.getRange().getStart();
        int end = current - 1;
        if (current == -1) {
            current = pred_start - 1;
            end = -1;
        }
        for (int k = current; k > end; --k) {
            if (!((String)chunks.get(k)).equals("B-NP")) continue;
            boolean simple_subj = false;
            boolean quotes_subj = this.patternExtractor.quotesSubj(extr, k);
            boolean relative_subj = false;
            boolean verb_conj = false;
            boolean app_clause = false;
            boolean which_who = false;
            boolean capitalized = false;
            boolean word_before_pred_conj = false;
            boolean intervening_and = false;
            boolean word_after_vp = false;
            boolean word_before_vp = false;
            int np_count_before = this.patternExtractor.getNPCountBefore(extr, k);
            int intervening_np = this.patternExtractor.getInterveningNPCount(extr, k);
            int punctuation_count = this.patternExtractor.getPunctuationCount(extr, k);
            simple_subj = this.patternExtractor.simpleSubj(extr, k);
            relative_subj = this.patternExtractor.relSubj(extr, k);
            verb_conj = this.patternExtractor.matchesVerbConjSimple(extr, k);
            app_clause = this.patternExtractor.matchesAppositiveClause(extr, current);
            which_who = ((String)words.get(k)).equals("which") || ((String)words.get(k)).equals("who") || ((String)words.get(k)).equals("that");
            capitalized = this.patternExtractor.getCapitalized(extr, k);
            punctuation_count = this.patternExtractor.getPunctuationCount(extr, k);
            word_before_pred_conj = this.patternExtractor.wordBeforePredIsConj(extr, k);
            intervening_and = this.patternExtractor.getInterveningConj(extr, k);
            word_after_vp = this.patternExtractor.wordAfterIsVP(extr, k);
            np_count_before = this.patternExtractor.getNPCountBefore(extr, k);
            word_before_vp = this.patternExtractor.wordBeforeIsVP(extr, k);
            intervening_np = this.patternExtractor.getInterveningNPCount(extr, k);
            DoubleFeatures featureMap = new DoubleFeatures();
            featureMap.put("simple_subj", this.toDouble(simple_subj));
            featureMap.put("quotes_subj", this.toDouble(quotes_subj));
            featureMap.put("relative_subj", this.toDouble(relative_subj));
            featureMap.put("verb_conj", this.toDouble(verb_conj));
            featureMap.put("app", this.toDouble(app_clause));
            featureMap.put("which_who", this.toDouble(which_who));
            featureMap.put("capitalized", this.toDouble(capitalized));
            featureMap.put("punct_count", this.toDouble(punctuation_count));
            featureMap.put("intervening_np_count", this.toDouble(intervening_np));
            featureMap.put("np_count_before", this.toDouble(np_count_before));
            featureMap.put("word_before_pred_conj", this.toDouble(word_before_pred_conj));
            featureMap.put("intervening_and", this.toDouble(intervening_and));
            featureMap.put("word_after_vp", this.toDouble(word_after_vp));
            featureMap.put("word_before_vp", this.toDouble(word_before_vp));
            return featureMap;
        }
        throw new IllegalStateException();
    }
}

