/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.argumentidentifier;

import com.google.common.collect.ImmutableList;
import edu.washington.cs.knowitall.argumentidentifier.PatternExtractor;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.extractor.conf.featureset.FeatureSet;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.util.ArrayList;
import java.util.List;

public class ArgLearnerFeatureSet
extends FeatureSet<ChunkedBinaryExtraction> {
    private final PatternExtractor patternExtractor = new PatternExtractor();

    public ArgLearnerFeatureSet() {
        super(ArgLearnerFeatureSet.featureNames());
    }

    public static List<String> featureNames() {
        ArrayList<String> names = new ArrayList<String>(34);
        names.add("correct_end");
        names.add("pred_starts_w_np");
        names.add("to_before_pred");
        names.add("conj_before_rel");
        names.add("which_before_rel");
        names.add("rel_one_verb");
        names.add("rel_to");
        names.add("rel_for");
        names.add("rel_in");
        names.add("rel_of");
        names.add("rel_on");
        names.add("pp_before_arg1");
        names.add("words_till_start");
        names.add("arg1_conf");
        names.add("arg1_proper");
        names.add("np_before_arg1");
        names.add("arg1_length");
        names.add("adj");
        names.add("comp");
        names.add("nest1");
        names.add("nest2");
        names.add("rel");
        names.add("npinf");
        names.add("doublenp");
        names.add("arg2_proper");
        names.add("verb_after_arg2");
        names.add("np_after_arg2");
        names.add("pp_after_arg2");
        names.add("words_till_end");
        names.add("arg2_conf");
        names.add("sent_less_than_10");
        names.add("sent_less_than_20");
        names.add("sent_more_than_20");
        names.add("extr_covers_phrase");
        return names;
    }

    private double toDouble(boolean bool) {
        if (bool) {
            return 0.0;
        }
        return 1.0;
    }

    private double toDouble(int num) {
        return 0.0 + (double)num;
    }

    private double toDouble(double num) {
        return num;
    }

    @Override
    public double featurize(String featureName, ChunkedBinaryExtraction extr) {
        if (featureName.equals("pred_starts_w_np")) {
            return this.toDouble(this.predStartsWithNP(extr));
        }
        if (featureName.equals("to_before_pred")) {
            return this.toDouble(this.toBeforePred(extr));
        }
        if (featureName.equals("conj_before_rel")) {
            return this.toDouble(this.conjBeforeRel(extr));
        }
        if (featureName.equals("which_before_rel")) {
            return this.toDouble(this.whichBeforeRel(extr));
        }
        if (featureName.equals("rel_one_verb")) {
            return this.toDouble(this.relOneVerb(extr));
        }
        if (featureName.equals("rel_to")) {
            return this.toDouble(this.relEndsWithToken(extr, "to"));
        }
        if (featureName.equals("rel_for")) {
            return this.toDouble(this.relEndsWithToken(extr, "for"));
        }
        if (featureName.equals("rel_in")) {
            return this.toDouble(this.relEndsWithToken(extr, "in"));
        }
        if (featureName.equals("rel_of")) {
            return this.toDouble(this.relEndsWithToken(extr, "of"));
        }
        if (featureName.equals("rel_on")) {
            return this.toDouble(this.relEndsWithToken(extr, "on"));
        }
        if (featureName.equals("correct_end")) {
            return this.toDouble(this.correctArg1End(extr));
        }
        if (featureName.equals("pp_before_arg1")) {
            return this.toDouble(this.ppBeforeArg1(extr));
        }
        if (featureName.equals("words_till_start")) {
            return this.toDouble(this.wordsTillStart(extr));
        }
        if (featureName.equals("arg1_conf")) {
            return this.toDouble(extr.getArgument1().getConfidence());
        }
        if (featureName.equals("arg1_proper")) {
            return this.toDouble(this.arg1IsProper(extr));
        }
        if (featureName.equals("np_before_arg1")) {
            return this.toDouble(this.npBeforeArg1(extr));
        }
        if (featureName.equals("arg1_length")) {
            return this.toDouble(this.arg1Length(extr));
        }
        if (featureName.equals("adj")) {
            return this.toDouble(this.patternExtractor.adjRelation(extr.getRelation()));
        }
        if (featureName.equals("comp")) {
            return this.toDouble(this.patternExtractor.complementClause(extr.getRelation()));
        }
        if (featureName.equals("nest1")) {
            return this.toDouble(this.patternExtractor.nestedRelation1(extr.getRelation()));
        }
        if (featureName.equals("nest2")) {
            return this.toDouble(this.patternExtractor.nestedRelation2(extr.getRelation()));
        }
        if (featureName.equals("rel")) {
            return this.toDouble(this.patternExtractor.npRelativeClause(extr.getRelation()));
        }
        if (featureName.equals("npinf")) {
            return this.toDouble(this.patternExtractor.npInfinitiveClause(extr.getRelation()));
        }
        if (featureName.equals("doublenp")) {
            return this.toDouble(this.patternExtractor.doubleNP(extr.getRelation()));
        }
        if (featureName.equals("arg2_proper")) {
            return this.toDouble(this.arg2IsProper(extr));
        }
        if (featureName.equals("verb_after_arg2")) {
            return this.toDouble(this.verbAfterArg2(extr));
        }
        if (featureName.equals("np_after_arg2")) {
            return this.toDouble(this.npAfterArg2(extr));
        }
        if (featureName.equals("pp_after_arg2")) {
            return this.toDouble(this.ppAfterArg2(extr));
        }
        if (featureName.equals("words_till_end")) {
            return this.toDouble(this.wordsTillStart(extr));
        }
        if (featureName.equals("arg2_conf")) {
            return this.toDouble(extr.getArgument2().getConfidence());
        }
        if (featureName.equals("sent_less_than_10")) {
            return this.toDouble(this.sentLength(extr, 0, 11));
        }
        if (featureName.equals("sent_less_than_20")) {
            return this.toDouble(this.sentLength(extr, 11, 21));
        }
        if (featureName.equals("sent_more_than_20")) {
            return this.toDouble(this.sentLength(extr, 21, Integer.MAX_VALUE));
        }
        if (featureName.equals("extr_covers_phrase")) {
            return this.toDouble(this.extrCoversPhrase(extr));
        }
        throw new IllegalArgumentException();
    }

    public int getIntValue(boolean bool, boolean dir) {
        if (bool == dir) {
            return 1;
        }
        return 0;
    }

    private boolean extrCoversPhrase(ChunkedBinaryExtraction e) {
        ChunkedSentence sent = e.getSentence();
        ImmutableList<String> tokens = sent.getTokens();
        Range x = e.getArgument1().getRange();
        Range y = e.getArgument2().getRange();
        Range r = e.getRelation().getRange();
        boolean adj = x.isAdjacentTo(r) && r.isAdjacentTo(y);
        int xs = x.getStart();
        boolean leftOk = xs == 0 || ((String)tokens.get(xs - 1)).equals(",") || ((String)tokens.get(xs - 1)).equals(".");
        int l = sent.getLength() - 1;
        int yr = y.getLastIndex();
        boolean rightOk = yr == l || ((String)tokens.get(yr + 1)).equals(",") || ((String)tokens.get(yr + 1)).equals(".");
        return adj && leftOk && rightOk;
    }

    private boolean sentLength(ChunkedBinaryExtraction e, int lower, int upper) {
        int a = lower;
        int b = upper;
        ChunkedSentence sent = e.getSentence();
        int len = sent.getLength();
        return a <= len && len < b;
    }

    private boolean npAfterArg2(ChunkedBinaryExtraction e) {
        ChunkedSentence sent;
        ChunkedArgumentExtraction arg2 = e.getArgument2();
        int lastArg2 = arg2.getRange().getLastIndex();
        return lastArg2 + 1 < (sent = arg2.getSentence()).getLength() && ((String)sent.getChunkTags().get(lastArg2 + 1)).equals("B-NP");
    }

    private boolean verbAfterArg2(ChunkedBinaryExtraction e) {
        String pastPosTag;
        ChunkedArgumentExtraction arg2 = e.getArgument2();
        int pastArg2 = arg2.getStart() + arg2.getLength();
        return pastArg2 < e.getSentence().getLength() && ((pastPosTag = (String)e.getSentence().getPosTags().get(pastArg2)).equals("MD") || pastPosTag.startsWith("V"));
    }

    private boolean npBeforeArg1(ChunkedBinaryExtraction e) {
        ChunkedArgumentExtraction arg1 = e.getArgument1();
        int start = arg1.getRange().getStart();
        if (start == 0) {
            return false;
        }
        ChunkedSentence sent = arg1.getSentence();
        return ((String)sent.getChunkTags().get(start - 1)).endsWith("-NP");
    }

    private boolean arg1IsProper(ChunkedBinaryExtraction e) {
        return this.isProperNp(e.getArgument2());
    }

    private boolean arg2IsProper(ChunkedBinaryExtraction e) {
        return this.isProperNp(e.getArgument2());
    }

    private boolean isProperNp(ChunkedExtraction e) {
        for (String tag : e.getPosTags()) {
            if (tag.startsWith("NNP") || tag.equals("DT") || tag.equals("IN")) continue;
            return false;
        }
        return true;
    }

    private boolean relEndsWithToken(ChunkedBinaryExtraction e, String t) {
        String token = t;
        ImmutableList<String> tokens = e.getRelation().getTokens();
        return ((String)tokens.get(tokens.size() - 1)).equals(token);
    }

    private boolean relOneVerb(ChunkedBinaryExtraction e) {
        ChunkedExtraction rel = e.getRelation();
        ImmutableList<String> posTags = rel.getPosTags();
        return posTags.size() == 1 && ((String)posTags.get(0)).startsWith("V");
    }

    private boolean whichBeforeRel(ChunkedBinaryExtraction e) {
        ChunkedExtraction pred = e.getRelation();
        int predStart = pred.getStart();
        if (predStart > 0) {
            String precPosTag = (String)e.getSentence().getPosTags().get(predStart - 1);
            String precPosToken = e.getSentence().getToken(predStart - 1);
            if (precPosTag.equals("WP") || precPosTag.equals("WDT") || precPosToken.equals("that")) {
                return true;
            }
        }
        return false;
    }

    private boolean conjBeforeRel(ChunkedBinaryExtraction e) {
        String precPosTag;
        ChunkedExtraction pred = e.getRelation();
        int predStart = pred.getStart();
        return predStart > 0 && (precPosTag = (String)e.getSentence().getPosTags().get(predStart - 1)).equals("CC");
    }

    public int wordsTillStart(ChunkedBinaryExtraction extr) {
        if (extr.getArgument1() == null || extr.getArgument1().getLength() < 1) {
            return -1;
        }
        int words_till_start = extr.getArgument1().getStart();
        return words_till_start;
    }

    public int arg1Length(ChunkedBinaryExtraction extr) {
        if (extr.getArgument1() == null || extr.getArgument1().getLength() < 1) {
            return -1;
        }
        return extr.getArgument1().getLength();
    }

    public int wordsTillEnd(ChunkedBinaryExtraction extr) {
        if (extr.getArgument2() == null || extr.getArgument2().getLength() < 1) {
            return -1;
        }
        int words_till_end = extr.getSentence().getLength() - (extr.getArgument2().getStart() + extr.getArgument2().getLength());
        return words_till_end;
    }

    public boolean ppAfterArg2(ChunkedBinaryExtraction extr) {
        if (this.wordsTillEnd(extr) > 0) {
            int end = extr.getArgument2().getStart() + extr.getArgument2().getLength();
            if (extr.getSentence().getChunkTag(end).equals("B-PP")) {
                return true;
            }
        }
        return false;
    }

    public boolean correctArg1End(ChunkedBinaryExtraction extr) {
        int i;
        int start = i = extr.getArgument1().getStart();
        while (i < extr.getArgument1().getStart() + extr.getArgument1().getLength()) {
            if (extr.getSentence().getChunkTag(i).equals("B-NP")) {
                start = i;
            }
            ++i;
        }
        return this.patternExtractor.findSubj(extr.getRelation(), start);
    }

    public boolean ppBeforeArg1(ChunkedBinaryExtraction extr) {
        if (this.wordsTillStart(extr) > 0) {
            int start = extr.getArgument1().getStart();
            if (extr.getSentence().getChunkTag(start - 1).equals("B-PP")) {
                return true;
            }
        }
        return false;
    }

    public boolean npBeforeArg2(ChunkedBinaryExtraction extr, boolean train) {
        for (int i = extr.getRelation().getStart() + extr.getRelation().getLength(); i < extr.getArgument2().getStart(); ++i) {
            if (!extr.getSentence().getChunkTag(i).contains("NP")) continue;
            return true;
        }
        return false;
    }

    public boolean predStartsWithNP(ChunkedBinaryExtraction extr) {
        return extr.getSentence().getPosTag(extr.getRelation().getStart()).contains("N");
    }

    public boolean toInPred(ChunkedBinaryExtraction extr, boolean train) {
        if (train) {
            for (int i = extr.getRelation().getStart(); i < extr.getArgument2().getStart(); ++i) {
                if (!extr.getSentence().getChunkTag(i).equals("B-VP") || !extr.getSentence().getPosTag(i).equals("TO")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean toBeforePred(ChunkedBinaryExtraction extr) {
        int i;
        boolean in_conj = false;
        for (i = extr.getRelation().getStart() - 1; i > -1; --i) {
            if (extr.getSentence().getPosTag(i).equals("CC") || extr.getSentence().getPosTag(i).equals(",")) {
                in_conj = true;
                break;
            }
            if (extr.getSentence().getChunkTag(i).contains("NP")) break;
        }
        int last_vp = extr.getRelation().getStart();
        if (in_conj) {
            boolean seen_vp = false;
            while (i > -1) {
                if (extr.getSentence().getPosTag(i).equals("CC") || extr.getSentence().getPosTag(i).equals(",")) {
                    seen_vp = false;
                } else if (extr.getSentence().getChunkTag(i).equals("B-VP")) {
                    seen_vp = true;
                    last_vp = i;
                } else if ((extr.getSentence().getChunkTag(i).equals("B-NP") || extr.getSentence().getChunkTag(i).equals("I-NP")) && seen_vp) break;
                if (extr.getSentence().getChunkTag(i).equals("B-VP") && extr.getSentence().getPosTag(i).equals("TO")) {
                    return true;
                }
                --i;
            }
        }
        boolean foundnp = false;
        for (i = last_vp; i > -1; --i) {
            if (extr.getSentence().getToken(i).equals("to")) {
                return true;
            }
            if (!extr.getSentence().getChunkTag(i).equals("B-NP") && !extr.getSentence().getChunkTag(i).equals("I-NP")) continue;
            foundnp = true;
            break;
        }
        if (foundnp) {
            return false;
        }
        return false;
    }
}

