/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.argumentidentifier;

import edu.washington.cs.knowitall.argumentidentifier.Arg1LocationFeatureGenerator;
import edu.washington.cs.knowitall.argumentidentifier.ArgLearner;
import edu.washington.cs.knowitall.extractor.conf.classifier.DecisionTree;
import edu.washington.cs.knowitall.extractor.conf.classifier.DoubleFeatures;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.io.IOException;
import java.net.URL;

public class ArgLocationClassifier {
    private static URL modelUrl;
    private DecisionTree classifier;
    private Arg1LocationFeatureGenerator featuregenerator;
    private ArgLearner.Mode mode;

    public ArgLocationClassifier(ArgLearner.Mode mode) throws IOException {
        try {
            modelUrl = ArgLocationClassifier.class.getResource("/r2a2-arg1loc.tree");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.mode = mode;
        if (mode == ArgLearner.Mode.LEFT) {
            this.featuregenerator = new Arg1LocationFeatureGenerator();
            this.setupClassifier(modelUrl);
        }
    }

    public double[] getArgBound(ChunkedExtraction predicate) {
        if (this.mode == ArgLearner.Mode.LEFT) {
            double[] resultsclassifier = new double[]{-1.0, 1.0};
            int classification = -1;
            int rightbound = -1;
            for (int k = predicate.getStart() - 1; k > -1 && classification == -1; --k) {
                if (!predicate.getSentence().getChunkTag(k).equals("B-NP")) continue;
                DoubleFeatures features = this.featuregenerator.extractFeatures(predicate, null, k, false);
                String outcome = this.classifier.classify(features);
                classification = outcome.equals("closest_np") ? 0 : -1;
                rightbound = k;
            }
            ++rightbound;
            while (rightbound < predicate.getStart() && predicate.getSentence().getChunkTag(rightbound).equals("I-NP")) {
                ++rightbound;
            }
            resultsclassifier[0] = rightbound;
            return resultsclassifier;
        }
        int bound = predicate.getStart() + predicate.getLength();
        if (!(predicate.getStart() + predicate.getLength() < predicate.getSentence().getLength() && (predicate.getSentence().getPosTag(predicate.getStart() + predicate.getLength()).startsWith("N") || predicate.getSentence().getPosTag(predicate.getStart() + predicate.getLength()).startsWith("J") || predicate.getSentence().getPosTag(predicate.getStart() + predicate.getLength()).startsWith("CD") || predicate.getSentence().getPosTag(predicate.getStart() + predicate.getLength()).startsWith("PRP") || predicate.getSentence().getPosTag(predicate.getStart() + predicate.getLength()).startsWith("WRB") || predicate.getSentence().getPosTag(predicate.getStart() + predicate.getLength()).startsWith("IN") || predicate.getSentence().getPosTag(predicate.getStart() + predicate.getLength()).startsWith("DT")))) {
            bound = -1;
        }
        double[] results = new double[]{bound, 1.0};
        return results;
    }

    private void setupClassifier(URL modelUrl) throws IOException {
        this.classifier = DecisionTree.fromModel(modelUrl);
    }
}

